#ifndef SETTING_DIALOG_FORM_H
#define SETTING_DIALOG_FORM_H

/*!
  \file
  \brief テーマ時計の設定ダイアログ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ui_ClockSettingDialogForm.h"


/*!
  \brief テーマ時計の設定ダイアログ
*/
class ClockSettingDialog : public QDialog, private Ui::ClockSettingDialog {
  Q_OBJECT;

  ClockSettingDialog(const ClockSettingDialog& rhs);
  ClockSettingDialog& operator = (const ClockSettingDialog& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void scalingSliderHandler(int value);
  void noAnimationCheckboxHandler(bool checked);

 public:
  /*!
    \brief コンストラクタ

    \param parent [i] 親ウィジット
  */
  explicit ClockSettingDialog(QDialog* parent = 0);
  ~ClockSettingDialog(void);


  /*!
    \brief 拡大率のスライドバーを設定

    \param value [i] スライドバーの値
  */
  void setScalingPercent(int value);

  void setNoAnimationCheckbox(bool checked);


signals:
  /*!
    \brief 拡大率の変更

    \param percent [o] 拡大率 [%]
  */
  void scalingValueChanged(int percent);

  void noAnimationStateChanged(bool checked);
};

#endif /* !SETTING_DIALOG_FORM_H */
