/*!
  \file
  \brief 配置部品の閲覧用

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QGraphicsSceneMouseEvent>
#include "PartsPlaceScene.h"


struct PartsPlaceScene::pImpl {

  // !!!
};


PartsPlaceScene::PartsPlaceScene(QObject* parent)
  : QGraphicsScene(parent), pimpl(new pImpl) {
}


PartsPlaceScene::~PartsPlaceScene(void) {
}


void PartsPlaceScene::mousePressEvent(QGraphicsSceneMouseEvent *mouseEvent) {

  if (mouseEvent->button() != Qt::LeftButton) {
    // 左クリック以外ならば、戻る
    return;
  }

  // クリック位置を取得
  QPointF point = mouseEvent->scenePos();
  //fprintf(stderr, "%f, %f\n", point.x(), point.y());

  // シグナルを投げる
  emit clicked(static_cast<int>(point.x()), static_cast<int>(point.y()));
}

