/*!
  \file
  \brief 設定ファイルの読み出しと保存管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QStringList>
#include <QFile>
#include <QTextStream>
#include "GenerateConfigHandler.h"
#include "PartsConfig.h"

#include <iostream>


struct GenerateConfigHandler::pImpl {

  std::vector<PartsConfig> parts_configs_;

  bool load(const char* file) {

    QFile data(file);
    if (! data.open(QFile::ReadOnly)) {
      return false;
    }

    std::vector<PartsConfig> configs;

    // UTF-8 の文字列を扱いたいため、QTextStream を使う
    QTextStream fin(&data);
    fin.setCodec("UTF-8");
    PartsConfig current_parts;
    while (true) {
      // 単語毎に読み出しを行い、単語に応じた変数に情報を格納する
      // !!!

      QString line = fin.readLine();
      if (line.isNull()) {
        // !!! この判定条件を、ループ条件にしたいなぁ...
        break;
      }
      if ((line.size() <= 0) || (line[0] == '#')) {
        continue;
      }

      QStringList tokens = line.split("\t");

      size_t tokens_n = tokens.size();
      QString first_token = tokens.at(0);

      if (tokens_n == 1) {
        if (first_token.size() <= 0) {
          continue;
        }

        if (first_token[0] == '\\') {
          // \<name> 読み出し後は、それまでの情報を格納してから次の情報を扱う
          storePartsInformation(configs, current_parts);
          current_parts.type = first_token.mid(1).toStdString();
          setDefaultTags(current_parts);
        }
      } else if (tokens_n == 2) {
        QString second_token = tokens.at(1);

        if (! first_token.compare("font")) {
          current_parts.font = second_token.toStdString();

        } else if (! first_token.compare("size")) {
          current_parts.font_size = second_token.toULong();

        } else if (! first_token.compare("fore")) {
          current_parts.fore_color = second_token.toStdString();

        } else if (! first_token.compare("back")) {
          current_parts.back_color = second_token.toStdString();

        } else if (! first_token.compare("offset")) {
          current_parts.offset = second_token.toULong();
        }
      } else if (! first_token.compare("tag")) {
        // タグ文字の格納
        tokens.pop_front();
        current_parts.tags.clear();

        while (! tokens.isEmpty()) {
          current_parts.tags.push_back(tokens.front());
          tokens.pop_front();
        }
      }
    }

    // 最後に読み出していた情報を格納する
    storePartsInformation(configs, current_parts);
    std::swap(parts_configs_, configs);

    return true;
  }


  void storePartsInformation(std::vector<PartsConfig>& configs,
                             const PartsConfig& parts) {

    if (! parts.type.empty()) {
      configs.push_back(parts);
    }
  }


  void setDefaultTags(PartsConfig& parts) {

    std::string parts_type = parts.type;

    if (! parts_type.compare("segment")) {
      parts.tags.clear();

      pushbackNumbers(parts);
      parts.tags.push_back(" ");
      parts.tags.push_back(":");
      parts.tags.push_back("A");
      parts.tags.push_back("P");

    } else if (! parts_type.compare("number")) {
      parts.tags.clear();
      pushbackNumbers(parts);

    } else if (! parts_type.compare("week")) {
      parts.tags.clear();

      // !!!

    } else if (! parts_type.compare("separator")) {
      parts.tags.clear();

      // !!!
    }
  }


  void pushbackNumbers(PartsConfig& parts) {

    parts.tags.push_back("0");
    parts.tags.push_back("1");
    parts.tags.push_back("2");
    parts.tags.push_back("3");
    parts.tags.push_back("4");
    parts.tags.push_back("5");
    parts.tags.push_back("6");
    parts.tags.push_back("7");
    parts.tags.push_back("8");
    parts.tags.push_back("9");
  }
};


GenerateConfigHandler::GenerateConfigHandler(void) : pimpl(new pImpl) {
}


GenerateConfigHandler::~GenerateConfigHandler(void) {
}


size_t GenerateConfigHandler::size(void) {

  return pimpl->parts_configs_.size();
}


const PartsConfig GenerateConfigHandler::getPartsConfig(size_t index) {

  if (index >= size()) {
    PartsConfig dummy;
    return dummy;
  }

  return pimpl->parts_configs_[index];
}


bool GenerateConfigHandler::load(const char* file) {

  return pimpl->load(file);
}


bool GenerateConfigHandler::save(void) {

  // !!!
  return false;
}


bool GenerateConfigHandler::saveAs(const char* file) {
  static_cast<void>(file);

  // !!!
  return false;
}
