#ifndef GENERATE_CONFIG_HANDLER_H
#define GENERATE_CONFIG_HANDLER_H

/*!
  \file
  \brief 設定ファイルの読み出しと保存管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>

class PartsConfig;


class GenerateConfigHandler {

  GenerateConfigHandler(const GenerateConfigHandler& rhs);
  GenerateConfigHandler& operator = (const GenerateConfigHandler& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:
  GenerateConfigHandler(void);
  ~GenerateConfigHandler(void);

  size_t size(void);
  const PartsConfig getPartsConfig(size_t index);

  bool load(const char* file);
  bool save(void);
  bool saveAs(const char* file);
};

#endif /* !GENERATE_CONFIG_HANDLER_H */
