/*!
  \file
  \brief ѡδ

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QColor>
#include "PartsConfig.h"


PartsConfig::PartsConfig(void)
  : type(""), font_size(14),
    fore_color("ffffff"), back_color("000000"), offset(0) {
}


QColor PartsConfig::encodeColor(const std::string& color_str) {

  if (color_str.size() != 6) {
    return QColor(Qt::white);
  }

  int r = strtol(color_str.substr(0, 2).c_str(), NULL, 16);
  int g = strtol(color_str.substr(2, 2).c_str(), NULL, 16);
  int b = strtol(color_str.substr(4, 2).c_str(), NULL, 16);

  return QColor(r, g, b);
}
