#ifndef PARTS_CONFIG_H
#define PARTS_CONFIG_H

/*!
  \file
  \brief パーツ設定の管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <string>
#include <vector>

class QString;
class QColor;


class PartsConfig {
public:
  std::string type;
  std::string font;
  size_t font_size;
  std::string fore_color;
  std::string back_color;
  size_t offset;
  std::vector<QString> tags;

  PartsConfig(void);

  static QColor encodeColor(const std::string& color_str);
};

#endif /* !PARTS_CONFIG_H */
