#ifndef PARTS_GENERATOR_WINDOW_H
#define PARTS_GENERATOR_WINDOW_H

/*!
  \file
  \brief 部品生成ツールのウィンドウ管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ui_PartsGeneratorWindowForm.h"


/*!
  \brief デジタル部品画像の生成用
*/
class PartsGeneratorWindow
  : public QMainWindow, private Ui::PartsGeneratorWindowForm {
  Q_OBJECT;

  PartsGeneratorWindow(const PartsGeneratorWindow& rhs);
  PartsGeneratorWindow& operator = (const PartsGeneratorWindow& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

  void closeEvent(QCloseEvent* event);

private slots:
  void aboutApplication(void);
  void newFile(void);
  void openFile(void);
  void saveFile(void);
  void update(void);
  void outputPixmap(void);

public:
  PartsGeneratorWindow(void);
  ~PartsGeneratorWindow(void);
};

#endif /* !PARTS_GENERATOR_WINDOW_H */
