#ifndef ANIMATION_MANATGER_H
#define ANIMATION_MANATGER_H

/*!
  \file
  \brief アニメーション管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QObject>
#include <vector>

class AnimationPattern;


/*!
  \brief アニメーション管理クラス
*/
class AnimationManager : public QObject {
  Q_OBJECT;

  AnimationManager(const AnimationManager& rhs);
  AnimationManager& operator = (const AnimationManager& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void updateAnimation(void);

public:

  /*!
    \brief コンストラクタ

    \param cycle_msec [i] 制御周期 [msec]
    \param patterns [i] アニメーション再生パターン
    \param parent [i] 親オブジェクト
  */
  AnimationManager(size_t cycle_msec,
                   const std::vector<AnimationPattern>& patterns,
                   QObject* parent = 0);
  ~AnimationManager(void);


  /*!
    \brief 評価
  */
  void evaluate(void);

signals:
  /*!
    \brief セルの更新

    \param cell_index [i] 描画するセル
  */
  void updateCell(int cell_index);
};

#endif /* !ANIMATION_MANATGER_H */
