#ifndef ANIMATION_PATTERN_H
#define ANIMATION_PATTERN_H

/*!
  \file
  \brief アニメーション再生パターン

  \author Satofumi KAMIMURA

  $Id$
*/

#include <vector>
#include <string>


/*!
  \brief セル用タグ
*/
class AnimationCellTag {
public:
  std::string simple_tag;       //!< cell_XXX
  std::string cell_tag;         //!< animation/cell_XXX/cell
  std::string xpos_tag;         //!< animation/cell_XXX/xpos
  std::string ypos_tag;         //!< animation/cell_XXX/ypos

  /*!
    \brief コンストラクタ

    \param index [i] ID 番号
  */
  AnimationCellTag(size_t index);
};


/*!
  \brief パターン用タグ
*/
class AnimationPatternTag {
public:
  std::string simple_tag;       //!< pattern_XXX
  std::string pattern_tag;      //!< animation/pattern_XXX/pattern
  std::string probability_tag;  //!< animation/pattern_XXX/probability
  std::string cycle_tag;        //!< animation/pattern_XXX/cycle

  /*!
    \brief コンストラクタ

    \param index [i] ID 番号
  */
  AnimationPatternTag(size_t index);
};


/*!
  \brief アニメーションの再生パターン管理
*/
class AnimationPattern {
public:
  double probability;           //!< 発生確率 / 秒 [1]
  size_t cycle_msec;            //!< 描画周期 [msec]
  std::vector<int> cells;       //!< セルのパターン
};

#endif /* !ANIMATION_PATTERN_H */
