/*!
  \file
  \brief std::string 文字列への変換

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QString>
#include <QLocale>
#include <QTextCodec>
#include <QSysInfo>
#include "ConvertStdStringPath.h"


namespace {
  std::string updateCodecType(const std::string& codec_name) {

    std::string codec_type = codec_name;

#ifdef Q_WS_WIN
    QSysInfo::WinVersion version = QSysInfo::windowsVersion();
    if (codec_type.empty() &&
        ((version == QSysInfo::WV_XP) || (version == QSysInfo::WV_2000))) {
      codec_type = "Shift-JIS";
    }
#endif

    // !!! Linux だと、EUC-JP か？

    return codec_type;
  }
};


const std::string qrk::toStdStringPath(const QString& text,
                                       const std::string& codec_name) {

  if (QLocale::system().name().compare("ja_JP")) {
    // 日本語ロケールでなければ、戻る
    return text.toStdString();
  }

  std::string codec_type = updateCodecType(codec_name);
  if (! codec_type.empty()) {
    // 文字コードの変換
    QTextCodec* codec = QTextCodec::codecForName(codec_type.c_str());
    if (codec && codec->canEncode(text)) {
      return QString(codec->fromUnicode(text)).toStdString();
    }
  }
  return text.toStdString();
}


const QString qrk::toQtStringPath(const std::string& text,
                                  const std::string& codec_name) {

  if (QLocale::system().name().compare("ja_JP")) {
    // 日本語ロケールでなければ、戻る
    return text.c_str();
  }

  std::string codec_type = updateCodecType(codec_name);
  if (! codec_type.empty()) {
    // 文字コードの変換
    QTextCodec* codec = QTextCodec::codecForName(codec_type.c_str());
    if (codec) {
      return codec->toUnicode(text.c_str());
    }
  }
  return text.c_str();
}
