#ifndef GENERATE_CONFIG_HANDLER_H
#define GENERATE_CONFIG_HANDLER_H

/*!
  \file
  \brief 設定ファイルの読み出しと保存管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>

class PartsConfig;


/*!
  \brief 描画部品の管理クラス
*/
class GenerateConfigHandler {

  GenerateConfigHandler(const GenerateConfigHandler& rhs);
  GenerateConfigHandler& operator = (const GenerateConfigHandler& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:
  GenerateConfigHandler(void);
  ~GenerateConfigHandler(void);

  /*!
    \brief 設定の初期化
  */
  void initialize(void);


  /*!
    \brief 部品数を返す

    \return 部品数
  */
  size_t size(void);


  /*!
    \brief 部品情報を返す

    \param index [i] 部品の格納インデックス

    \return 部品情報への参照
  */
  PartsConfig& getPartsConfig(size_t index);


  /*!
    \brief 読み出し

    \param file [i] ファイル名

    \retval true 正常
    \retval false エラー
  */
  bool load(const char* file);


  /*!
    \brief 保存

    \retval true 正常
    \retval false エラー

    \attention 未実装
  */
  bool save(void);


  /*!
    \brief 名前を付けて保存

    \param file [i] ファイル名

    \retval true 正常
    \retval false エラー

    \attention 未実装
  */
  bool saveAs(const char* file);
};

#endif /* !GENERATE_CONFIG_HANDLER_H */
