/*!
  \file
  \brief パーツ設定の管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QColor>
#include "PartsConfig.h"


PartsConfig::PartsConfig(void)
  : type(""), font_size(14),
    fore_color("ffffff"), back_color("777777"), offset(0) {
}


QColor PartsConfig::encodeColor(const std::string& color_str) {

  if (color_str.size() != 6) {
    return QColor(Qt::white);
  }

  int r = strtol(color_str.substr(0, 2).c_str(), NULL, 16);
  int g = strtol(color_str.substr(2, 2).c_str(), NULL, 16);
  int b = strtol(color_str.substr(4, 2).c_str(), NULL, 16);

  return QColor(r, g, b);
}


const std::string PartsConfig::decodeColor(int r, int g, int b) {

  QString color_str;
  color_str.sprintf("%02x%02x%02x", r, g, b);
  return color_str.toStdString();
}


// フォントスタイルの取得
QFont::Style PartsConfig::fontStyle(const std::string& style_name) {

  QString style_string = QString(style_name.c_str());

  if (style_string.contains("Italic")) {
    return QFont::StyleItalic;

  } else if (style_string.contains("Oblique")) {
    return QFont::StyleOblique;

  } else {
    return QFont::StyleNormal;
  }
}


// フォント属性の取得
QFont::Weight PartsConfig::fontWeight(const std::string& weight_name) {

  QString weight_string = QString(weight_name.c_str());

  if (weight_string.contains("Bold")) {
    return QFont::Bold;

  } else if (weight_string.contains("Light")) {
    return QFont::Light;

  } else {
    return QFont::Normal;
  }
}
