#ifndef PARTS_CONFIG_H
#define PARTS_CONFIG_H

/*!
  \file
  \brief パーツ設定の管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QFont>
#include <string>
#include <vector>

class QString;
class QColor;


/*!
  \brief 描画部品の情報管理
*/
class PartsConfig {
public:
  std::string type;             //!< 出力名
  std::string font_name;        //!< フォント名
  std::string font_style_name;  //!< フォントスタイル名
  size_t font_size;             //!< フォントサイズ
  std::string fore_color;       //!< フォントの色
  std::string back_color;       //!< 背景色
  size_t offset;                //!< フォント間のオフセット
  std::vector<QString> tags;    //!< 描画文字列

  PartsConfig(void);

  /*!
    \brief 色文字列を色に変換

    RRGGBB 形式を QColor に変換する

    \param color_str [i] RRGGBB 形式の文字列

    \return QColor 型の色
  */
  static QColor encodeColor(const std::string& color_str);


  /*!
    \brief 色を色文字列に変換

    \param r [i] Red [0, 255]
    \param g [i] Green [0, 255]
    \param b [i] Blue [0, 255]

    \return RRGGBB 形式の文字列
  */
  static const std::string decodeColor(int r, int g, int b);


  /*!
    \brief フォントスタイルの取得

    \param style_name [i] フォントスタイル文字列

    \return フォントスタイル
  */
  static QFont::Style fontStyle(const std::string& style_name);


  /*!
    \brief フォント属性の取得

    \param weight_name [i] フォント属性文字列

    \return フォント属性
  */
  static QFont::Weight fontWeight(const std::string& weight_name);
};

#endif /* !PARTS_CONFIG_H */
