/*!
  \file
  \brief アニメーション再生パターン

  \author Satofumi KAMIMURA

  $Id$
*/

#include "AnimationPattern.h"


AnimationCellTag::AnimationCellTag(size_t index) {

  char simple_name[] = "cell_000";
  snprintf(simple_name, strlen(simple_name) + 1, "cell_%03d", index);
  this->simple_tag = simple_name;

  char base_name[] = "animation/cell_000";
  snprintf(base_name, strlen(base_name) + 1, "animation/cell_%03d", index);

  this->cell_tag = std::string(base_name) + "/cell";
  this->xpos_tag = std::string(base_name) + "/xpos";
  this->ypos_tag = std::string(base_name) + "/ypos";
}


AnimationPatternTag::AnimationPatternTag(size_t index) {

  char simple_name[] = "pattern_000";
  snprintf(simple_name, strlen(simple_name) + 1, "pattern_%03d", index);
  this->simple_tag = simple_name;

  char base_name[] = "animation/pattern_000";
  snprintf(base_name, strlen(base_name) + 1, "animation/pattern_%03d", index);

  this->pattern_tag = std::string(base_name) + "/pattern";
  this->probability_tag = std::string(base_name) + "/probability";
  this->cycle_tag = std::string(base_name) + "/cycle";
}


AnimationPattern::AnimationPattern(void) : probability(0.0), cycle_msec(20) {
}
