#ifndef TO_SJIS_STRING_H
#define TO_SJIS_STRING_H

/*!
  \file
  \brief SJIS 文字列への変換

  Windows 環境において、ファイルのパスを std::string 形式にするために用いる

  \author Satofumi KAMIMURA

  $Id$

  \attention Linux 環境で、日本語文字がどう扱われるかは未検証
*/

class QString;


namespace qrk {

  /*!
    \brief 文字列の SJIS 変換

    コーデック名の指定がなければ、OS 毎に適切なコーデックが使われる

    \param text [i] 変換前の文字列
    \param codec_name [i] コーデック名

    \return 変換後の文字列
  */
  extern const std::string toStdStringPath(const QString& text,
                                           const std::string& codec_name = "");


  /*!
    \brief 文字列の UTF-16 変換

    コーデック名の指定がなければ、OS 毎に適切なコーデックが使われる

    \param text [i] 変換前の文字列
    \param codec_name [i] コーデック名

    \return SJIS 変換後の文字列
  */
  extern const QString toQtStringPath(const std::string& text,
                                      const std::string& codec_name = "");
};

#endif /* !TO_SJIS_STRING_H */
