/*!
  \file
  \brief Qt による lm_tmclock の実装

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QApplication>
#include <QTranslator>
#include <QLocale>
#include <iostream>
#include "ThemeClockWidget.h"


namespace {
  typedef struct {
    QString theme_file;
    bool position_specified;
  } options_t;
};


// 使い方の表示
static void printHelp(const char* program_name) {
  const QString message =
    QString("usage:\n"
            "\t%1 [options]\n"
            "\n"
            "options\n"
            "  --help, -h                  print this message.\n"
            //"  --version, -v               output version infromation.\n"
            "  --theme <file>              Specify the theme file.\n"
            "  --geometry <position>       Place to <position>.\n"
            "\n"
            "Report bugs to <satofumi@users.sourceforge.jp>.")
    .arg(program_name);

  std::cout << message.toStdString() << std::endl;
}


// オプション処理
static options_t optionHandler(int argc, char *argv[]) {

  // デフォルト設定
  options_t option;
  option.theme_file = "";
  option.position_specified = false;

  if (argc > 1) {
    // 引数があれば、とりあえずそれをテーマファイル名として登録する
    // 最初の引数をテーマとみなすのは、qt パラメータとの場合分けが困難なため
    option.theme_file = argv[1];
  }
  for (int i = 1; i < argc; ++i) {
    if ((! strcmp("--theme", argv[i])) || (! strcmp("-t", argv[i]))) {
      if (i + 1 < argc) {
        // テーマ指定されていれば、それをテーマ名とする
        option.theme_file = argv[i];
      }

    } else if ((! strcmp("--geometry", argv[i])) ||
               (! strcmp("-geometry", argv[i]))) {
      // 位置指定があれば、指定位置をデフォルト設定は無効にする
      option.position_specified = true;

#if 0
    } else if ((! strcmp("--version", argv[i])) || (! strcmp("-v", argv[i]))) {
      printf("qtmclock X.X.X\n");
      exit(0);
#endif

    } else if ((! strcmp("--help", argv[i])) || (! strcmp("-h", argv[i]))) {
      printHelp(argv[0]);
      exit(1);
    }
  }
  return option;
}


//! メイン関数
int main(int argc, char *argv[]) {

  QApplication app(argc, argv);

  // ロケールの適用
  QString locale = QLocale::system().name();
  QTranslator translator;
  translator.load("qtmclock_" + locale);
  app.installTranslator(&translator);

  // オプションの解析
  const options_t option = optionHandler(argc, argv);

  // アプリケーションの起動
  ThemeClockWidget widget(option.theme_file, option.position_specified);
  widget.show();
  return app.exec();
}
