#ifndef PARTS_DRAW_WIDGET_H
#define PARTS_DRAW_WIDGET_H

/*!
  \file
  \brief 部品描画ウィジット

  \author Satofumi KAMIMURA

  $Id: PartsDrawWidget.h 261 2009-01-22 06:48:10Z satofumi $
*/

#include <QWidget>
#include <memory>

class PartsConfig;


/*!
  \brief パーツ描画ウィジット
*/
class PartsDrawWidget : public QWidget
{
  PartsDrawWidget(const PartsDrawWidget& rhs);
  PartsDrawWidget& operator = (const PartsDrawWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

  /*!
    \brief
  */
  void paintEvent(QPaintEvent* event);

public:
  /*!
    \brief コンストラクタ

    \param[in] parent 親ウィジット
  */
  PartsDrawWidget(QWidget* parent = 0);
  ~PartsDrawWidget(void);

  /*!
    \brief

    \param parts [i]
  */
  void updatePreview(const PartsConfig& parts);

  /*!
    \brief

    \param file_name [i]
  */
  bool outputPixmap(const QString& file_name);
};

#endif /* !PARTS_DRAW_WIDGET_H */
