#ifndef SETTING_CONFIG_H
#define SETTING_CONFIG_H

/*!
  \file
  \brief XML 設定ファイルの管理

  \author Satofumi KAMIMURA

  $Id: SettingConfig.h 276 2009-10-22 03:44:32Z satofumi $
*/

#include <QMap>
#include <QString>
#include <memory>


/*!
  \brief XML 設定ファイルの管理クラス
*/
class SettingConfig
{
public:
  /*!
    \brief コンストラクタ

    \param[in] config_file 設定の XML ファイル
  */
  explicit SettingConfig(const std::string& config_file);


  /*!
    \brief コンストラクタ

    \param[out] tags タグ情報の格納先
    \param[in] data XML データ配列
  */
  explicit SettingConfig(QMap<std::string, std::string>& tags,
                         QByteArray& data);
  ~SettingConfig(void);


  /*!
    \brief 値の取得

    \param[in] tag タグ

    \retval 値
  */
  const std::string getValue(const std::string& tag);


  /*!
    \brief 値の設定

    \param[in] tag タグ
    \param[in] value 値
  */
  void setValue(const std::string& tag, const std::string& value);


  /*!
    \brief アーカイブファイルの更新

    \retval true 正常
    \retval false エラー
  */
  void save(void);

private:
  SettingConfig(void);
  SettingConfig(const SettingConfig& rhs);
  SettingConfig& operator = (const SettingConfig& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !SETTING_CONFIG_H */
