#ifndef THEME_RESOURCE_H
#define THEME_RESOURCE_H

/*!
  \file
  \brief テーマ時計のリソース

  \author Satofumi KAMIMURA

  $Id: ThemeResource.h 263 2009-01-30 14:48:10Z satofumi $
*/

#include <QPoint>
#include <QMap>
#include <string>

class QPixmap;
class QRect;


/*!
  \brief テーマ時計のリソース
*/
class ThemeResource
{
public:
  QMap<std::string, QPixmap*> pixmap; //!< 画像
  QMap<std::string, QRect> offset;    //!< 位置
  QMap<std::string, std::string> option;  //!< オプション
};


/*!
  \brief デジタル位置の設定を読み出し

  \param[in] digital_positions デジタル文字位置
  \param[in] tags 配置情報リソース
*/
extern void loadDigitalPosition(QVector<QPoint>& digital_positions,
                                const QMap<std::string, std::string>& tags);

/*!
  \overload
*/
extern void loadDigitalPosition(QVector<QPoint>& digital_positions,
                                QMap<std::string, QPoint>& parts_positions);

/*!
  \brief カレンダー部品位置の設定読み出し

  \param calendar_positions [i]
  \param tags [i]
*/
extern void loadCalendarPosition(QVector<QPoint>& calendar_positions,
                                 const QMap<std::string, std::string>& tags);

/*!
  \overload
*/
extern void loadCalendarPosition(QVector<QPoint>& calendar_positions,
                                 QMap<std::string, QPoint>& parts_positions);

#endif /* !THEME_RESOURCE_H */
