#ifndef PARTS_PLACE_SCENE_H
#define PARTS_PLACE_SCENE_H

/*!
  \file
  \brief 配置部品の閲覧用

  \author Satofumi KAMIMURA

  $Id: PartsPlaceScene.h 261 2009-01-22 06:48:10Z satofumi $
*/

#include <QGraphicsScene>


/*!
  \brief 部品配置の閲覧シーンクラス
*/
class PartsPlaceScene : public QGraphicsScene
{
  Q_OBJECT;

  PartsPlaceScene(const PartsPlaceScene& rhs);
  PartsPlaceScene& operator = (const PartsPlaceScene& rhs);

protected:
  /*!
    \brief イベント制御

    \param[in,out] mouseEvent イベント
  */
  void mousePressEvent(QGraphicsSceneMouseEvent *mouseEvent);

public:
  /*!
    \brief コンストラクタ

    \param[in] parent 親ウィジット
  */
  PartsPlaceScene(QObject* parent = 0);
  ~PartsPlaceScene(void);

signals:
  /*!
    \brief クリック位置の送信シグナル

    \param[in] x ウィジット内クリック X 値
    \param[in] y ウィジット内クリック Y 値
  */
  void clicked(int x, int y);
};

#endif /* !PARTS_PLACE_SCENE_H */
