#ifndef THEME_CLOCK_DRAW_H
#define THEME_CLOCK_DRAW_H

/*!
  \file
  \brief テーマ時計の描画

  \author Satofumi KAMIMURA

  $Id: ThemeClockDraw.h 276 2009-10-22 03:44:32Z satofumi $
*/

#include "ClockPartsDraw.h"
#include <QWidget>
#include <memory>


/*!
  \brief テーマ時計の描画クラス
*/
class ThemeClockDraw : public QWidget
{
  Q_OBJECT;

public:
  /*!
    \brief コンストラクタ

    \param[in] parent 親ウィジット
  */
  ThemeClockDraw(QWidget* parent = 0);
  ~ThemeClockDraw(void);


  /*!
    \brief テーマファイルの読み出し

    \param[in] theme_file テーマファイル
    \param[in] key RRDA キー

    \retval true 成功
    \retval エラー
  */
  bool loadThemeFile(const QString& theme_file, const char* key = "LMTC");


  /*!
    \brief テーマのリソースからの読み出し

    qtmclock_config のプレビュー表示用
  */
  bool loadThemeResource(const QMap<std::string, QPixmap*>& pixmaps,
                         const QMap<std::string, QRect>& offset,
                         const QVector<QPoint>& digital_positions,
                         const QVector<QPoint>& calendar_positions,
                         const QMap<std::string, std::string>& option);


  /*!
    \brief テーマファイル名を返す

    \return テーマファイル名

    \attention テーマがロードされていない場合は、"" を返す
  */
  const QString getThemeFile(void);


  /*!
    \brief テーマ時計の再描画を行う

    \param[in] sec_offset 描画時間のオフセット [秒]
    \param[in] parent 親ウィジット
    \param[in] cell_index 描画するアニメーションセル
  */
  void redraw(int sec_offset = 0, QWidget* parent = NULL,
              int cell_index = ClockPartsDraw::InvalidCellIndex);


  /*!
    \brief 透過領域の取得

    \return 透過領域
  */
  QRegion* getRegion(void);


  /*!
    \brief 描画の拡大率を設定

    \param[in] percent 描画の拡大率
  */
  void updateScalingPercent(size_t percent);


  /*!
    \brief アニメーション する / しない の設定

    \param[in] on アニメーションするとき true
  */
  void setAnimationOn(bool on);


signals:
  /*!
    \brief 終了シグナルを投げる
  */
  void previewClose(void);


protected:
  /*!
    \brief 描画イベント処理

    \param[in,out] event イベント
  */
  void paintEvent(QPaintEvent* event);


  /*!
    \brief Qt のクローズイベント

    \param[in,out] event イベント
  */
  void closeEvent(QCloseEvent* event);


private slots:
  void evaluateAnimation(void);
  void updateCell(int index);


private:
  ThemeClockDraw(const ThemeClockDraw& rhs);
  ThemeClockDraw& operator = (const ThemeClockDraw& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /*! THEME_CLOCK_DRAW_H */
