#ifndef THEME_CLOCK_WIDGET_H
#define THEME_CLOCK_WIDGET_H

/*!
  \file
  \brief ThemeClock の描画処理

  \author Satofumi KAMIMURA

  $Id: ThemeClockWidget.h 288 2012-06-15 13:16:21Z satofumi $
*/

#include <QWidget>
#include <QSystemTrayIcon>
#include <memory>


/*!
  \brief テーマ時計のウィジット管理クラス
*/
class ThemeClockWidget : public QWidget
{
  Q_OBJECT;

public:
  /*!
    \brief コンストラクタ

    \param[in] theme_file テーマファイル名
    \param[in] position_specified 描画位置がシステムに渡されている場合 true
    \param[in] parent 親ウィジット
  */
  ThemeClockWidget(const QString& theme_file, const bool position_specified,
                   QWidget* parent = 0);
  ~ThemeClockWidget(void);

signals:
  /*!
    \brief ウインドウを閉じる
  */
  void close(void);


protected:
  /*!
    \brief Qt のリサイズイベント処理

    \param[in,out] event イベント
  */
  void resizeEvent(QResizeEvent* event);


  /*!
    \brief Qt のマウス押下イベント処理

    \param[in,out] event イベント
  */
  void mousePressEvent(QMouseEvent* event);


  /*!
    \brief Qt のマウス移動イベント処理

    \param[in,out] event イベント
  */
  void mouseMoveEvent(QMouseEvent* event);


  /*!
    \brief Qt のドラッグイベント

    \param[in,out] event イベント
  */
  void dragEnterEvent(QDragEnterEvent* event);


  /*!
    \brief Qt ドラッグ移動イベント

    \param[in,out] event イベント
  */
  void dragMoveEvent(QDragEnterEvent* event);


  /*!
    \brief Qt のドロップイベント

    \param[in,out] event イベント
  */
  void dropEvent(QDropEvent* event);


private slots:
  void redraw(void);
  void configHandler(void);
  void changeScaling(int percent);
  void changeNoAnimation(bool checked);
  void placeTopHandler(bool checked);


private:
  ThemeClockWidget(void);
  ThemeClockWidget(const ThemeClockWidget& rhs);
  ThemeClockWidget& operator = (const ThemeClockWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !THEME_CLOCK_WIDGET_H */
