/*!
  \file
  \brief リリース用ダイアログ

  \author Satofumi KAMIMURA

  $Id: ReleaseDialog.cpp 261 2009-01-22 06:48:10Z satofumi $
*/

#include "ReleaseDialog.h"
#include "ArchiveConfig.h"

using namespace std;


ReleaseDialog::ReleaseDialog(QDialog* parent) : QDialog(parent)
{
  setupUi(this);

  // アイコンの適用
  setWindowIcon(QIcon(":icons/qtmclock_config_icon"));

  // イベントの接続
  connect(this, SIGNAL(accepted()), this, SLOT(acceptedHandler()));
}


ReleaseDialog::~ReleaseDialog(void)
{
}


void ReleaseDialog::acceptedHandler(void)
{
  emit release(file_name_edit_->text(), key_edit_->text());
}


void ReleaseDialog::setDefaultValue(const string& release_file,
                                    const string& rrda_key)
{
  file_name_edit_->setText(release_file.c_str());
  key_edit_->setText(rrda_key.c_str());
}
