/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import junit.extensions.eclipse.quick.JavaElements;
import junit.extensions.eclipse.quick.Messages;
import junit.extensions.eclipse.quick.QuickJUnitAction;
import junit.extensions.eclipse.quick.QuickJUnitPlugin;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class JUnitLaunchAction
extends QuickJUnitAction {
    private String mode;
    private ILaunchShortcut launchShortcut;

    public JUnitLaunchAction(ILaunchShortcut launchShortcut, String mode) {
        this.launchShortcut = launchShortcut;
        this.mode = mode;
    }

    private IJavaElement getElementOfJavaEditor() throws JavaModelException {
        if (this.javaEditor == null) {
            return null;
        }
        IJavaElement element = SelectionConverter.getElementAtOffset((JavaEditor)this.javaEditor);
        if (JavaElements.isTestMethod(element)) {
            return element;
        }
        return JavaElements.getPrimaryTypeOf(element);
    }

    private IJavaElement getTargetElement(IAction action) throws JavaModelException {
        IJavaElement element = this.getSelectedElement();
        if (element == null || element.getElementType() < 5) {
            return element;
        }
        IType type = JavaElements.getPrimaryTypeOf(element);
        if (type == null) {
            return element;
        }
        ITypeHierarchy superTypeHierarchy = type.newSupertypeHierarchy(null);
        IType[] superTypes = superTypeHierarchy.getAllInterfaces();
        int i = 0;
        while (i < superTypes.length) {
            IType superType = superTypes[i];
            if (superType.getFullyQualifiedName().equals("junit.framework.Test")) {
                return element;
            }
            ++i;
        }
        this.openInformation(action, Messages.getString("JUnitLaunchAction.notJUnitElement"));
        return null;
    }

    private IJavaElement getSelectedElement() throws JavaModelException {
        IJavaElement element = this.getElementOfJavaEditor();
        return element == null ? this.javaElement : element;
    }

    public void run(IAction action) {
        try {
            IJavaElement element = this.getTargetElement(action);
            if (element == null) {
                return;
            }
            StructuredSelection sel = new StructuredSelection(new Object[]{element});
            this.launchShortcut.launch((ISelection)sel, this.mode);
        }
        catch (JavaModelException e) {
            QuickJUnitPlugin.getDefault().handleSystemError((Exception)((Object)e), this);
        }
    }
}

