/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import junit.extensions.eclipse.quick.JavaElements;
import junit.extensions.eclipse.quick.JavaTypes;
import junit.extensions.eclipse.quick.Messages;
import junit.extensions.eclipse.quick.NamingRules;
import junit.extensions.eclipse.quick.PopupTableSelector;
import junit.extensions.eclipse.quick.QuickJUnitAction;
import junit.extensions.eclipse.quick.QuickJUnitPlugin;
import junit.extensions.eclipse.quick.TestingPair;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.wizards.NewTestCaseCreationWizard;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenTestingPairAction
extends QuickJUnitAction {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private IType getTypeOfJavaEditor() throws JavaModelException {
        if (this.javaEditor == null) {
            return null;
        }
        return SelectionConverter.getTypeAtOffset((JavaEditor)this.javaEditor);
    }

    private IType getTypeOfJavaElement() {
        return JavaElements.getPrimaryTypeOf(this.javaElement);
    }

    private IType getTargetType() throws JavaModelException {
        IType targetType = this.getTypeOfJavaEditor();
        if (targetType != null) {
            return targetType;
        }
        return this.getTypeOfJavaElement();
    }

    private IType selectType(IAction action, List types) {
        PopupTableSelector selector = new PopupTableSelector(this.getShell(), types);
        selector.setTitle(action.getText());
        selector.setCommandForward(action.getActionDefinitionId());
        selector.setLabelProvider((ILabelProvider)new TypeLabelProvider());
        return (IType)selector.select();
    }

    private void openPairWizard(IType targetType, String[] pairNames) throws JavaModelException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWizard wizard = this.createNewPairWizard(targetType, workbench);
        Shell parent = workbench.getActiveWorkbenchWindow().getShell();
        WizardDialog dialog = new WizardDialog(parent, wizard);
        dialog.create();
        this.setUpNewClassCreationWizard(wizard, targetType, pairNames);
        WorkbenchHelp.setHelp((Control)dialog.getShell(), (String)"org.eclipse.ui.ide.new_wizard_shortcut_context");
        dialog.open();
    }

    private String extractTypeName(String fullName) {
        int index = fullName.lastIndexOf(46);
        if (index == -1) {
            return fullName;
        }
        return fullName.substring(index + 1);
    }

    private void setUpNewClassCreationWizard(IWizard wizard, IType targetType, String[] pairNames) {
        if (pairNames.length == 0) {
            return;
        }
        try {
            String typeName = this.extractTypeName(pairNames[0]);
            Field pageField = wizard.getClass().getDeclaredField("fPage");
            pageField.setAccessible(true);
            Object page = pageField.get(wizard);
            Class<?> clazz = page.getClass();
            Class[] classArray = new Class[2];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            classArray[1] = Boolean.TYPE;
            Method setTypeNameMethod = clazz.getMethod("setTypeName", classArray);
            setTypeNameMethod.setAccessible(true);
            setTypeNameMethod.invoke(page, typeName, Boolean.TRUE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private IWizard createNewPairWizard(IType targetType, IWorkbench workbench) throws JavaModelException {
        if (JavaTypes.isTest(targetType)) {
            NewClassCreationWizard wizard = new NewClassCreationWizard();
            StructuredSelection selection = new StructuredSelection((Object)targetType.getPackageFragment());
            wizard.init(workbench, (IStructuredSelection)selection);
            return wizard;
        }
        NewTestCaseCreationWizard wizard = new NewTestCaseCreationWizard();
        StructuredSelection selection = new StructuredSelection((Object)targetType);
        wizard.init(workbench, (IStructuredSelection)selection);
        return wizard;
    }

    public void run(IAction action) {
        try {
            IType targetType = this.getTargetType();
            if (targetType == null) {
                return;
            }
            String[] pairNames = this.createTestPair().getPairClassNames(targetType.getFullyQualifiedName());
            List testPairTypes = this.findPairTypes(pairNames);
            if (testPairTypes.isEmpty()) {
                this.runWhenTestingPairNotExist(action, targetType, pairNames);
            } else {
                this.openTestingPair(action, testPairTypes);
            }
        }
        catch (JavaModelException e) {
            QuickJUnitPlugin.getDefault().handleSystemError((Exception)((Object)e), this);
        }
        catch (CoreException e) {
            QuickJUnitPlugin.getDefault().handleSystemError((Exception)((Object)e), this);
        }
    }

    private List findPairTypes(String[] pairNames) throws JavaModelException {
        IJavaProject[] projects = this.getJavaProjects();
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        int i = 0;
        while (i < projects.length) {
            IJavaProject project = projects[i];
            int j = 0;
            while (j < pairNames.length) {
                IType pairType = project.findType(pairNames[j]);
                if (pairType != null) {
                    result.add(pairType);
                }
                ++j;
            }
            ++i;
        }
        return new ArrayList(result);
    }

    private void runWhenTestingPairNotExist(IAction action, IType targetType, String[] pairNames) throws JavaModelException {
        if (pairNames.length == 0) {
            this.openInformation(action, Messages.getString("OpenTestingPairAction.testPairNotFound", targetType.getFullyQualifiedName()));
            return;
        }
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)action.getText(), (String)Messages.getString("OpenTestingPairAction.testPairNotFoundAndConfirm"))) {
            this.openPairWizard(targetType, pairNames);
        }
    }

    private void openTestingPair(IAction action, List testPairTypes) throws CoreException {
        IType selectedType = null;
        selectedType = testPairTypes.size() >= 2 ? this.selectType(action, testPairTypes) : (IType)testPairTypes.get(0);
        if (selectedType == null) {
            return;
        }
        JavaUI.openInEditor((IJavaElement)selectedType);
    }

    private TestingPair createTestPair() {
        TestingPair testPair = new TestingPair();
        IPreferenceStore store = QuickJUnitPlugin.getDefault().getPreferenceStore();
        String[] rules = new NamingRules(store).getEnableValues();
        int i = 0;
        while (i < rules.length) {
            testPair.addNamingRule(rules[i]);
            ++i;
        }
        return testPair;
    }

    private static class TypeLabelProvider
    extends LabelProvider {
        TypeLabelProvider() {
        }

        public String getText(Object element) {
            return ((IType)element).getFullyQualifiedName();
        }
    }
}

