/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.SWTKeySupport;

public class PopupTableSelector {
    private Shell shell;
    private List items;
    private Object selection;
    private List backwardKeySequenceBindings = null;
    private List forwardKeySequenceBindings = null;
    private String commandForward;
    private String commandBackward;
    private ILabelProvider labelProvider;
    private String title = "";
    private boolean forward = true;

    public PopupTableSelector(Shell shell, List items) {
        this.shell = shell;
        this.items = items;
    }

    public void setCommandBackward(String string) {
        this.commandBackward = string;
    }

    public void setCommandForward(String string) {
        this.commandForward = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.labelProvider = provider;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object select() {
        Object var11_11;
        ICommand backwardCommand;
        ICommand forwardCommand;
        this.selection = null;
        final Shell dialog = new Shell(this.shell, 0);
        Display display = dialog.getDisplay();
        dialog.setLayout((Layout)new FillLayout());
        Table table = new Table((Composite)dialog, 65540);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tc = new TableColumn(table, 0);
        tc.setResizable(false);
        tc.setText(this.title);
        this.addItems(table, this.items);
        int tableItemCount = table.getItemCount();
        switch (tableItemCount) {
            case 0: {
                break;
            }
            case 1: {
                table.setSelection(0);
                break;
            }
            default: {
                table.setSelection(this.forward ? 1 : table.getItemCount() - 1);
            }
        }
        tc.pack();
        table.pack();
        Rectangle tableBounds = table.getBounds();
        tableBounds.height = Math.min(tableBounds.height, table.getItemHeight() * 22);
        table.setBounds(tableBounds);
        dialog.pack();
        tc.setWidth(table.getClientArea().width);
        table.setFocus();
        table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                PopupTableSelector.this.cancel(dialog);
            }
        });
        Rectangle dialogBounds = dialog.getBounds();
        Rectangle displayBounds = display.getClientArea();
        Rectangle parentBounds = dialog.getParent().getBounds();
        dialogBounds.x = parentBounds.x + (parentBounds.width - dialogBounds.width) / 2;
        dialogBounds.y = parentBounds.y + (parentBounds.height - dialogBounds.height) / 2;
        if (!displayBounds.contains(dialogBounds.x, dialogBounds.y) || !displayBounds.contains(dialogBounds.x + dialogBounds.width, dialogBounds.y + dialogBounds.height)) {
            dialogBounds.x = (displayBounds.width - dialogBounds.width) / 2;
            dialogBounds.y = (displayBounds.height - dialogBounds.height) / 2;
        }
        dialog.setLocation(dialogBounds.x, dialogBounds.y);
        ICommandManager commandManager = PlatformUI.getWorkbench().getCommandSupport().getCommandManager();
        if (this.commandForward != null && (forwardCommand = commandManager.getCommand(this.commandForward)).isDefined()) {
            this.forwardKeySequenceBindings = forwardCommand.getKeySequenceBindings();
        }
        if (this.commandBackward != null && (backwardCommand = commandManager.getCommand(this.commandBackward)).isDefined()) {
            this.backwardKeySequenceBindings = backwardCommand.getKeySequenceBindings();
        }
        try {
            dialog.open();
            this.addMouseListener(table, dialog);
            this.addKeyListener(table, dialog);
            this.addTraverseListener(table);
            while (!dialog.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Throwable throwable) {
            var11_11 = null;
            if (!dialog.isDisposed()) {
                this.cancel(dialog);
            }
            this.forwardKeySequenceBindings = null;
            this.backwardKeySequenceBindings = null;
            throw throwable;
        }
        {
            var11_11 = null;
        }
        if (!dialog.isDisposed()) {
            this.cancel(dialog);
        }
        this.forwardKeySequenceBindings = null;
        this.backwardKeySequenceBindings = null;
        return this.selection;
    }

    private void addItems(Table table, List items) {
        TableItem tableItem = null;
        int i = 0;
        while (i < items.size()) {
            Object item = items.get(i);
            tableItem = new TableItem(table, 0);
            tableItem.setText(this.labelProvider.getText(item));
            tableItem.setData(item);
            ++i;
        }
    }

    private void addMouseListener(final Table table, final Shell dialog) {
        table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                PopupTableSelector.this.ok(dialog, table);
            }

            public void mouseDown(MouseEvent e) {
                PopupTableSelector.this.ok(dialog, table);
            }

            public void mouseUp(MouseEvent e) {
                PopupTableSelector.this.ok(dialog, table);
            }
        });
    }

    private final void addTraverseListener(Table table) {
        table.addTraverseListener(new TraverseListener(){

            public final void keyTraversed(TraverseEvent event) {
                event.doit = false;
            }
        });
    }

    private void addKeyListener(final Table table, final Shell dialog) {
        table.addKeyListener(new KeyListener(){
            private boolean firstKey = true;
            private boolean quickReleaseMode = false;

            public void keyPressed(KeyEvent e) {
                List keyStrokes;
                IKeySequenceBinding keySequenceBinding;
                Iterator iterator;
                int keyCode = e.keyCode;
                char character = e.character;
                int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                KeyStroke keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator);
                boolean acceleratorForward = false;
                boolean acceleratorBackward = false;
                if (PopupTableSelector.this.commandForward != null && PopupTableSelector.this.forwardKeySequenceBindings != null) {
                    iterator = PopupTableSelector.this.forwardKeySequenceBindings.iterator();
                    while (iterator.hasNext()) {
                        keySequenceBinding = (IKeySequenceBinding)iterator.next();
                        keyStrokes = keySequenceBinding.getKeySequence().getKeyStrokes();
                        if (keyStrokes.isEmpty() || !keyStrokes.get(keyStrokes.size() - 1).equals(keyStroke)) continue;
                        acceleratorForward = true;
                        break;
                    }
                }
                if (PopupTableSelector.this.commandBackward != null && PopupTableSelector.this.backwardKeySequenceBindings != null) {
                    iterator = PopupTableSelector.this.backwardKeySequenceBindings.iterator();
                    while (iterator.hasNext()) {
                        keySequenceBinding = (IKeySequenceBinding)iterator.next();
                        keyStrokes = keySequenceBinding.getKeySequence().getKeyStrokes();
                        if (keyStrokes.isEmpty() || !keyStrokes.get(keyStrokes.size() - 1).equals(keyStroke)) continue;
                        acceleratorBackward = true;
                        break;
                    }
                }
                if (character == '\r' || character == '\n') {
                    PopupTableSelector.this.ok(dialog, table);
                } else if (acceleratorForward) {
                    if (this.firstKey && e.stateMask != 0) {
                        this.quickReleaseMode = true;
                    }
                    int index = table.getSelectionIndex();
                    table.setSelection((index + 1) % table.getItemCount());
                } else if (acceleratorBackward) {
                    int index;
                    if (this.firstKey && e.stateMask != 0) {
                        this.quickReleaseMode = true;
                    }
                    table.setSelection((index = table.getSelectionIndex()) >= 1 ? index - 1 : table.getItemCount() - 1);
                } else if (keyCode != 65536 && keyCode != 0x400000 && keyCode != 262144 && keyCode != 131072 && keyCode != 0x1000002 && keyCode != 0x1000001 && keyCode != 0x1000003 && keyCode != 0x1000004) {
                    PopupTableSelector.this.cancel(dialog);
                }
                this.firstKey = false;
            }

            public void keyReleased(KeyEvent e) {
                int keyCode = e.keyCode;
                int stateMask = e.stateMask;
                IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                boolean stickyCycle = store.getBoolean("STICKY_CYCLE");
                if (!stickyCycle && (this.firstKey || this.quickReleaseMode) && keyCode == stateMask) {
                    PopupTableSelector.this.ok(dialog, table);
                }
            }
        });
    }

    private static char convertCharacter(char c) {
        return c >= '\u0000' && c <= '\u001f' ? (char)(c + 64) : Character.toUpperCase(c);
    }

    private void cancel(Shell dialog) {
        this.selection = null;
        dialog.close();
    }

    private void ok(Shell dialog, Table table) {
        TableItem[] items = table.getSelection();
        if (items != null && items.length == 1) {
            this.selection = items[0].getData();
        }
        dialog.close();
    }
}

