/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import junit.extensions.eclipse.quick.NamingRule;
import org.eclipse.jface.preference.IPreferenceStore;

public class NamingRules {
    private IPreferenceStore store;
    private final String STORE_ID = "NamingRules";

    public NamingRules(IPreferenceStore store) {
        this.store = store;
    }

    public List get() {
        String value = this.store.getString("NamingRules");
        if (value == null || value.length() == 0) {
            return this.getDefault();
        }
        return this.stringToList(value);
    }

    public String[] getEnableValues() {
        List namingRules = this.get();
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < namingRules.size()) {
            NamingRule rule = (NamingRule)namingRules.get(i);
            if (rule.isEnabled()) {
                result.add(rule.getValue());
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public void set(List namingRules) {
        this.store.setValue("NamingRules", this.listToString(namingRules));
    }

    private String listToString(List namingRules) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < namingRules.size()) {
            if (i != 0) {
                buf.append(',');
            }
            NamingRule rule = (NamingRule)namingRules.get(i);
            buf.append(String.valueOf(rule.getValue()) + ":" + rule.isEnabled());
            ++i;
        }
        return buf.toString();
    }

    private List stringToList(String string) {
        ArrayList<NamingRule> result = new ArrayList<NamingRule>();
        StringTokenizer st = new StringTokenizer(string, ",");
        while (st.hasMoreTokens()) {
            String column = st.nextToken();
            int index = column.indexOf(58);
            if (index == -1) continue;
            String value = column.substring(0, index);
            Boolean enabled = Boolean.valueOf(column.substring(index + 1));
            result.add(new NamingRule(value, enabled));
        }
        return result;
    }

    public List getDefault() {
        ArrayList<NamingRule> result = new ArrayList<NamingRule>();
        result.add(new NamingRule("${package}.${type}Test", true));
        result.add(new NamingRule("${package}.${type}PDETest", false));
        return result;
    }
}

