/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import java.util.Dictionary;
import junit.extensions.eclipse.quick.Messages;
import junit.extensions.eclipse.quick.QuickJUnitException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class QuickJUnitPlugin
extends AbstractUIPlugin {
    private static QuickJUnitPlugin plugin;

    public QuickJUnitPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static QuickJUnitPlugin getDefault() {
        return plugin;
    }

    public IStatus createSystemErrorStatus(Exception ex, Object caller) {
        int severity = 4;
        String message = ex.getMessage();
        if (message == null) {
            message = "";
        }
        MultiStatus errorStatus = new MultiStatus(this.getID(), severity, message, (Throwable)ex);
        Dictionary headers = this.getBundle().getHeaders();
        String providerName = "" + headers.get("Bundle-Vendor");
        message = String.valueOf(Messages.getString("QuickJUnitPlugin.systemError.providerNameLabel")) + providerName;
        errorStatus.add(this.createStatus(severity, message));
        String pluginName = "" + headers.get("Bundle-Name");
        message = String.valueOf(Messages.getString("QuickJUnitPlugin.systemError.pluginNameLabel")) + pluginName;
        errorStatus.add(this.createStatus(severity, message));
        String pluginId = this.getBundle().getSymbolicName();
        message = String.valueOf(Messages.getString("QuickJUnitPlugin.systemError.pluginIdLabel")) + pluginId;
        errorStatus.add(this.createStatus(severity, message));
        String version = "" + headers.get("Bundle-Version");
        message = String.valueOf(Messages.getString("QuickJUnitPlugin.systemError.versionLabel")) + version;
        errorStatus.add(this.createStatus(severity, message));
        Class<?> klass = caller instanceof Class ? (Class<?>)caller : caller.getClass();
        message = String.valueOf(Messages.getString("QuickJUnitPlugin.systemError.classLabel")) + klass.getName();
        errorStatus.add(this.createStatus(severity, message, 4, ex));
        return errorStatus;
    }

    public IStatus createStatus(int severity, String message) {
        return this.createStatus(severity, message, 0, null);
    }

    private IStatus createStatus(int severity, String message, int code, Exception ex) {
        return new Status(severity, this.getID(), code, message, (Throwable)ex);
    }

    public void handleSystemError(Exception ex, Object caller) {
        IStatus status = this.createSystemErrorStatus(ex, caller);
        this.getLog().log(status);
        ErrorDialog.openError(null, (String)Messages.getString("QuickJUnitPlugin.systemError.dialog.title"), (String)Messages.getString("QuickJUnitPlugin.systemError.dialog.message"), (IStatus)status);
    }

    public void logSystemError(Exception ex, Object caller) {
        IStatus status = this.createSystemErrorStatus(ex, caller);
        this.getLog().log(status);
    }

    public void logSystemErrorMessage(String message, Object caller) {
        IStatus status = this.createSystemErrorStatus((Exception)((Object)new QuickJUnitException(message)), caller);
        this.getLog().log(status);
    }

    public String getID() {
        return this.getBundle().getSymbolicName();
    }
}

