# QuickIP/Child.pm - QuickIP ̎qG[WFgiqG[WFgM惊XgɑΉj
#
# Last Change: 28-Jan-2006.
# Written By: Kouichi NANASHIMA <seven@mail7.ph>
package QuickIP::Child;

use Ipmsg::Agent;
use Ipmsg::HostList;
use QuickIP::Admin;

use strict;

use vars qw($VERSION $THISNAME @ISA @EXPORT @EXPORT_OK);

require Exporter;

@ISA = qw(Exporter Ipmsg::Agent);
@EXPORT = qw(ChildCmdAdd ChildCmdRemove ChildCmdMember ChildCmdPrivate ChildCmdQuit ChildCmdSep ChildUserPrefix);

$VERSION = 0.21;
$THISNAME = "QuickIP ChildAgent module Ver.$VERSION";

# qG[WFgR}h̒萔
# oǉ
use constant ChildCmdAdd      => 'Add';
# o폜
use constant ChildCmdRemove   => 'Remove';
# o\
use constant ChildCmdMember   => 'Member';
# vCx[g[hw
use constant ChildCmdPrivate  => 'Private';
# qG[WFgI
use constant ChildCmdQuit     => 'Quit';
# R}hXg
use constant ChildCmdList     =>
  '('.ChildCmdAdd.'|'.ChildCmdRemove.'|'.ChildCmdMember.'|'.ChildCmdPrivate.'|'.ChildCmdQuit.')';
# R}hƈ̋؂蕶
use constant ChildCmdSep      => ':';
# R}hpK\
my $ChildCmdRegexp = '^\s*'.ChildCmdList.'('.ChildCmdSep.'([^'.ChildCmdSep.']+))?$';

# qG[WFg[U̐ړ
use constant ChildUserPrefix  => 'QuickIP-';

# bZ[W̒萔
# s؂L
use constant Linesep          => "\n";
# Mҕ\bZ[W
use constant MsgFrom          => '񂩂̃bZ[W'.Linesep.Linesep;
# oǉ̃bZ[W
use constant MsgAdd           => '񂪒ǉ܂B'.Linesep;
# o폜̃bZ[W
use constant MsgRemove        => '񂪍폜܂B'.Linesep;
# vCx[g[h̃bZ[W
use constant MsgPrivate       => '̃bZ[W̓vCx[g[hłB'.Linesep.'oւ̔zMƃo̒ǉ/폜͂Ȃ܂B'.Linesep;
# G[bZ[W̐ړ
use constant MsgErrPrefix     => '';
# bZ[WMs̃G[bZ[W
use constant MsgErrCannotSend => 'ɂ͑Mł܂łB'.Linesep;
# bZ[WMs̃G[bZ[W
use constant MsgErrNotSend    => 'QuickIP̃G[WFgȂ̂őM܂łB'.Linesep;
# odo^̃G[bZ[W
use constant MsgErrDuplicate  => '͂łɓo^Ă܂B'.Linesep;
# oo^̃G[bZ[W
use constant MsgErrNotExist   => '͓o^Ă܂B'.Linesep;
# [UbZ[WƃVXebZ[W̋؂蕶
use constant UserSystemSep    => '--'.Linesep;

# vpeBANZXp萔
# ǗpG[WFg
use constant Admin            => 17;
# zMbZ[WXg
use constant MessageList      => 18;
# oXg
use constant MemberList       => 19;
# Jʒm}bv
use constant ReadCheckMap     => 20;
# G[WFgtO
use constant AliveFlg          => 21;
# Mς݃bZ[WL[
use constant RecvMsgQueue      => 22;

sub new {
  my $pkg = shift;
  my %options = @_;
  my $admin = %options->{Admin};

  # G[WFg̍쐬
  my $self = Ipmsg::Agent->new(%options);

  $self->[Admin] = $admin;
  $self->[MessageList] = [];
  $self->[MemberList] = [];
  $self->[ReadCheckMap] = {};
  $self->[AliveFlg] = 1;
  $self->[RecvMsgQueue] = [];

  return bless $self, $pkg;
}

# ǗpG[WFg擾
sub admin {
  my $self = shift;

  return $self->[Admin];
}

# zMbZ[WXg擾
sub messagelist {
  my $self = shift;

  return $self->[MessageList];
}

# oXg擾
sub memberlist {
  my $self = shift;

  return $self->[MemberList];
}

# Jʒm}bv擾
sub readcheckmap {
  my $self = shift;

  return $self->[ReadCheckMap];
}

# G[WFgǂ𔻒肷
sub isAlive {
  my $self = shift;

  return ($self->[AliveFlg] == 1);
}

# Mς݃bZ[WL[擾
sub recvmsgqueue {
  my $self = shift;

  return $self->[RecvMsgQueue];
}

# OC
sub Login {
  my $self = shift;

  my $ext;
  $ext  = $self->hostinfo->nickname;
  $ext .= $self->delim_group.$self->hostinfo->group;

  return $self->broadcast( Command => $self->ipmsg_cmd( 'IPMSG_BR_ABSENCE' ) + $self->hostinfo->command, Ext => $ext);
}

# OAEg
sub Logout {
  my $self = shift;

  for my $if ($self->netif) {
    while (my $recv = $self->recv(NetIF => $if, FROMCHECK => 1)) {
      MsgProcess($recv);
    }
  }
  while ($self->ForwardMessage()) {
  }
  $self->SUPER::Logout;
  for my $if ( $self->netif ){
    while( $if->remainqueue ){ $if->send_queue; }
  }
}

# bZ[WM
sub recv {
  my $self = shift;
  my %options = @_;
  my $recvmsgqueue = $self->recvmsgqueue;

  # \Pbg̃bZ[WSĎMăL[Ɋi[
  while (my $recv = $self->SUPER::recv(%options)) {
    # Mς݂̃bZ[W̓L[Ɋi[Ȃ
    my $isRecv = 0;
    for (my $i = 0; $i <= $#$recvmsgqueue; $i++) {
      my $msg = @$recvmsgqueue[$i];
      if ($msg->packetn eq $recv->packetn and
          $msg->addr eq $recv->addr and
          $msg->port eq $recv->port) {
        $isRecv = 1;
        last;
      }
    }
    push @$recvmsgqueue, $recv if (!$isRecv);
  }

  my $retval = undef;
  if ($#$recvmsgqueue >= 0) {
    $retval = @$recvmsgqueue[0];
    splice @$recvmsgqueue, 0, 1;
  }
  return $retval;
}

# bZ[W]
sub ForwardMessage {
  my $self = shift;
  my $admin = $self->admin;

  # ǗpG[WFgzXgXgW̏ꍇ̓bZ[WMȂ
  my $time = time;
  my $lastEntry = $admin->lastentry;
  if ($admin->isWait) {
    return 1;
  }

  my ($msg, $auto, $recv, $forwardlist) = $self->RemoveMessage();
  if ($msg eq undef) {
    return 0;
  }
  my @hostlist = ();
  foreach my $forward (@$forwardlist) {
    my @hostpartlist = $admin->SearchHost($forward);
    if ($#hostpartlist >= 0) {
      foreach my $host (@hostpartlist) {
        # QuickIPO[ṽG[WFgɂ͑MȂ
        if ($host->group eq $self->hostinfo->group) {
          $auto = $auto.MsgErrPrefix.$host->nickname.MsgErrNotSend;
        } else {
          push @hostlist, $host;
        }
      }
    } else {
      $auto = $auto.MsgErrPrefix.$forward.MsgErrCannotSend;
    }
  }
  my $ext = $msg;
  $ext = $ext.UserSystemSep.$auto if $auto ne '';

  foreach my $host (@hostlist) {
    my $send = $self->message(
      PeerAddr  => $host->addr,
      PeerPort  => $host->port,
      Ext       => $ext);
    $send = $send->sendmsg->sendcheckopt;
    if ($recv->secretopt and $recv->user ne $host->user) {
      $self->AddReadCheckMap($send, $recv);
      $send = $send->secretopt;
    }
    $send->queue;
  }
  return 1;
}

# bZ[WR}h
sub MsgProcess {
  my $self = shift;
  my $recv = shift;

  # vCx[g[h̃[obNpf[^
  my $isPrivate = 0;
  my @rollbackMemberlist = ();
  foreach my $member (@{$self->memberlist}) {
    push @rollbackMemberlist, $member;
  }

  if ($recv) {
    if ($recv->sendmsg and $recv->autoretopt == 0) {
      my $linesep = Linesep;
      my @lines = split(/$linesep/, $recv->ext);
      my $msg = '';
      my $auto = '';
      my @forwardList = @{$self->memberlist};
      foreach my $line (@lines) {
        # R}hsǂ𔻒
        if ($line =~ /$ChildCmdRegexp/) {
          # R}hƈ擾
          my $operation = $1;
          my $operand = $3;
          if ($operation eq ChildCmdAdd) {
            # R}hoǉ̏ꍇ
            my @result = $self->AddProcess($operation, $operand);
            $msg = $msg.shift(@result);
            $auto = $auto.shift(@result);
            foreach my $forward (@{shift(@result)}) {
              push @forwardList, $forward;
            }
          } elsif ($operation eq ChildCmdRemove) {
            # R}ho폜̏ꍇ
            my @result = $self->RemoveProcess($operation, $operand);
            $msg = $msg.shift(@result);
            $auto = $auto.shift(@result);
            foreach my $forward (@{shift(@result)}) {
              push @forwardList, $forward;
            }
          } elsif ($operation eq ChildCmdMember) {
            # R}hoꗗ\̏ꍇ
            my @result = $self->MemberProcess($operation, $operand);
            $msg = $msg.shift(@result);
            $auto = $auto.shift(@result);
            foreach my $forward (@{shift(@result)}) {
              push @forwardList, $forward;
            }
          } elsif ($operation eq ChildCmdQuit) {
            # R}hXg̏ꍇ
            my $admin = $self->admin;
            if ($recv->host eq $admin->hostinfo->host &&
                $recv->port eq $admin->hostinfo->port) {
              my @result = $self->QuitProcess($operation, $operand);
              $msg = $msg.shift(@result);
              $auto = $auto.shift(@result);
            }
          } elsif ($operation eq ChildCmdPrivate) {
            # R}hvCx[g[hw̏ꍇ
            $isPrivate = 1;
            my @result = $self->PrivateProcess($operation, $operand);
            $msg = $msg.shift(@result);
            $auto = shift(@result).$auto;
            foreach my $forward (@{shift(@result)}) {
              push @forwardList, $forward;
            }
          }
        } else {
          $msg = $msg.$line.Linesep;
        }
      }

      # bZ[WvCx[gw肳Ăꍇf[^[obN
      if ($isPrivate and $self->isAlive) {
        @forwardList = ($recv->user);
        $self->[MemberList] = \@rollbackMemberlist;
      }

      $msg = $recv->user.MsgFrom.$msg;
      $self->AddMessage($msg, $auto, $recv, \@forwardList);
    } elsif ($recv->readmsg) {
      # MbZ[WJʒmłꍇ
      my $packet = $self->RemoveReadCheckMap($recv);
      if ($packet) {
        my $send = $self->message(
          PeerAddr => $packet->addr,
          PeerPort => $packet->port,
          User     => $recv->user,
          Ext      => $packet->packetn);
          $send->readmsg->queue;
      }
    }
  }
}

# oǉ
sub AddProcess {
  my $self = shift;
  my $operation = shift;
  my $operand = shift;
  my $memberlist = $self->memberlist;

  my $msg = '';
  my $auto = '';
  my @forward = ();
  if (join('', grep /$operand/, @$memberlist) eq '') {
    push @$memberlist, $operand;
    push @forward, $operand;
    $auto = $auto.$operand.MsgAdd;
  } else {
    $auto = $auto.MsgErrPrefix.$operand.MsgErrDuplicate;
  }

  return ($msg, $auto, \@forward);
}

# o폜
sub RemoveProcess {
  my $self = shift;
  my $operation = shift;
  my $operand = shift;
  my $memberlist = $self->memberlist;

  my $msg = '';
  my $auto = '';
  my @forward = ();

  my $index = -1;
  for (my $i = 0; $i <= $#$memberlist; $i++) {
    if (@$memberlist[$i] eq $operand) {
      $index = $i;
      last;
    }
  }

  if ($index != -1) {
    $auto = $auto.$operand.MsgRemove;
    splice (@$memberlist, $index, 1);
  }
  else {
    $auto = $auto.MsgErrPrefix.$operand.MsgErrNotExist;
  }

  return ($msg, $auto, \@forward);
}

# o\
sub MemberProcess {
  my $self = shift;
  my $operation = shift;
  my $operand = shift;
  my $memberlist = $self->memberlist;

  my $msg = '';
  my $auto = '';
  my @forward = ();
  foreach my $member (@$memberlist) {
    $msg = $msg.$member.Linesep;
  }

  return ($msg, $auto, \@forward);
}

# vCx[g[hw菈
sub PrivateProcess {
  my $self = shift;
  my $operation = shift;
  my $operand = shift;

  my $msg = '';
  my $auto = '';
  my @forward = ();
  $auto = $auto.MsgPrivate;

  return ($msg, $auto, \@forward);
}

# G[WFgI
sub QuitProcess {
  my $self = shift;
  my $operation = shift;
  my $operand = shift;

  my $msg = '';
  my $auto = '';
  $self->[AliveFlg] = 0;

  return ($msg, $auto);
}

# zMbZ[Wǉ
sub AddMessage {
  my $self = shift;
  my $msg = shift;
  my $auto = shift;
  my $recv = shift;
  my $memberlist = shift;
  my $messagelist = $self->messagelist;

  if ($#$memberlist < 0) {
    return;
  }
  my @memberlist2 = ();
  foreach my $member (@$memberlist) {
    push @memberlist2, $member;
  }
  my $content = [$msg, $auto, $recv, $memberlist];
  push @$messagelist, $content;
}

# zMbZ[W폜
sub RemoveMessage {
  my $self = shift;
  my $messagelist = $self->messagelist;

  if ($#$messagelist < 0) {
    return (undef, undef, undef, undef);
  } else {
    return @{pop @$messagelist};
  }
}

# Jʒm]ǉ
sub AddReadCheckMap {
  my $self = shift;
  my $send = shift;
  my $recv = shift;
  my $map = $self->readcheckmap;

  $map->{$send->packetn.ChildCmdSep.$send->addr.ChildCmdSep.$send->port} = $recv;
}

# Jʒm]폜
sub RemoveReadCheckMap {
  my $self = shift;
  my $recv = shift;
  my $map = $self->readcheckmap;

  my $key = $recv->ext.ChildCmdSep.$recv->addr.ChildCmdSep.$recv->port;
  my $value = $map->{$key};
  delete $map->{$key};
  return $value;
}

1;
