<?php
	require_once 'magpierss/rss_fetch.inc';
	//require_once 'magpierss/rss_utils.inc';
	define('MAGPIE_OUTPUT_ENCODING', 'UTF-8');
	define('MAGPIE_CACHE_ON', 0);
	define('MAGPIE_CACHE_DIR', '../var/rss_cache');
	define('MAGPIE_CACHE_AGE', 3600);
	define('MAGPIE_DEBUG', 1);
	$max_items = 5;
	$rss_news = get_rss_news();
	foreach($rss_news as $site=>$rss_profile) {
		echo <<<EOS
site:   $site<br>
about:  $rss_profile[about]<br>
update: $rss_profile[update_per_sec] sec.<br>
type:   $rss_profile[type]<br>
EOS;
		foreach($rss_profile['rss'] as $subject=>$url) {
			echo $subject."<br>\n";
			$rss = fetch_rss($url);
			mb_convert_variables('EUC-JP','UTF-8',$rss);
			$items = array_slice($rss->items, 0, $max_items);
			foreach ($items as $item ) {
				//echo "item=";print_r($item);echo "<br>";
				$title = $item['title'];
				$url   = $item['link'];
				//$body = mb_strimwidth ($item['description'], 0, 200 ,'...','EUC-JP');
				$body = $item['description'];
				list($tmp_date,$time) = explode('T',$item[dc][date]);
				list($year,$month,$day) = explode('-',$tmp_date);
				list($time,$zone) = explode('+',$time);
				list($hour,$min,$sec) = explode(':',$time);
				$hour = $hour + $zone;
				$date=date('Y/m/d H:i',gmmktime($hour,$min,$sec,$month,$day,$year));
				echo <<<EOS
<p>
($item[dc][date])<br>
$date&nbsp;<a href=$url>$title</a><br>
$body
</p>
EOS;
			}
		}
	
	}
function get_rss_news() {
	$rss_news = array(
		'BP'=>array(
			'about'=>'http://www.nikkeibp.co.jp/jp/tools/rss2006.html',
			'update_per_sec'=>600,
			'type'=>'RSS1.0',
			'rss'=>array(
				''=>'http://www.nikkeibp.co.jp/index.rdf',
				'˥塼'=>'http://www.nikkeibp.co.jp/news/flash/index.rdf',
				'ȡб'=>'http://www.nikkeibp.co.jp/news/rss/business/index.rdf',
				'IT'=>'http://www.nikkeibp.co.jp/news/rss/it/index.rdf',
				'¤'=>'http://www.nikkeibp.co.jp/news/rss/manufacture/index.rdf',
				'Ķ'=>'http://www.nikkeibp.co.jp/news/rss/ecology/index.rdf',
				''=>'http://www.nikkeibp.co.jp/news/rss/china/index.rdf',
				''=>'http://www.nikkeibp.co.jp/news/rss/construction/index.rdf'
				//'ӥͥϢ'=>'http://www.nikkeibp.co.jp/style/biz/rss/column.rdf',
				//'饤եϢ'=>'http://www.nikkeibp.co.jp/style/life/rss/column.rdf',
				//'饤ե˥塼'=>'http://www.nikkeibp.co.jp/style/life/rss/news.rdf',
				//'ɬɵ'=>'http://nikkeibp.weblogs.jp/topics/index.rdf',
				//'ԽΤΤ餻'=>'http://nikkeibp.weblogs.jp/info/index.rdf'
			)
		),
		/*
		'asahi.com'=>array(
			'about'=>'http://www.asahi.com/information/service/rss.html',
			'update_per_sec'=>600,
			'type'=>'RSS1.0',
			'rss'=>array(''=>'http://www3.asahi.com/rss/index.rdf')
		),
		'Bulknews'=>array(
			'about'=>'http://bulknews.net/rss/',
			'update_per_sec'=>1800,
			'type'=>'RSS0.91',
			'rss'=>array(
				'INTERNET Watch'=>'http://bulknews.net/rss/rdf.cgi?InternetWatch',
				'PC Watch'=>'http://bulknews.net/rss/rdf.cgi?PCWatch',
				'AV Watch'=>'http://bulknews.net/rss/rdf.cgi?AVWatch',
				'Watch'=>'http://bulknews.net/rss/rdf.cgi?KtaiWatch',
				'ǥWatch'=>'http://bulknews.net/rss/rdf.cgi?DCWatch',
				'Broadband Watch'=>'http://bulknews.net/rss/rdf.cgi?BBWatch',
				'GAME Watch'=>'GAME Watch',
				'Japan.internet.com'=>'http://bulknews.net/rss/rdf.cgi?InternetCom',
				'Wired News'=>'http://bulknews.net/rss/rdf.cgi?HotWired',
				'ITmedia'=>'http://bulknews.net/rss/rdf.cgi?ITmedia',
				'ZAKZAK'=>'http://bulknews.net/rss/rdf.cgi?ZakZak',
				'ݡĥʥ'=>'http://bulknews.net/rss/rdf.cgi?SportsNavi',
				'ե.com'=>'http://bulknews.net/rss/rdf.cgi?Famitsu'
			)
		)
		*/
	);
	return $rss_news;
}
?>