<?php
/**
 * Smarty nano_wiki modifier plugin
 *
 * Type:     modifier<br>
 * Name:     nano_wiki<br>
 * Purpose:  very small wiki processor.
 * @link http://quicty.zubapita.jp/
 *          nano_wiki (Quicty online manual)
 * @author   Tomoyuki Negishi <tomoyu-n at zubapita dot jp>
 * @param string
 * @return string
 */
function smarty_modifier_nano_wiki($body,$header_level=3) {
	$primary_header = 'h'.$header_level;
	$secondry_header = 'h'.($header_level+1);
	$thirdry_header = 'h'.($header_level+2);
	$strings = explode("\n",$body);
	foreach($strings as $string) {
		// hearline
		if(preg_match("/^----$/",$string)) {
			$string = '<hr />';
		// block
		} elseif(preg_match("/^(\||-|\+|>)(.*)$/",$string,$matches)) {
			if(!$block_type) {
				if($matches[1]=='|') {
					$block_type = 'table';
					$attributes = " cellspacing=\"0\"";
				} elseif($matches[1]=='-') {
					$block_type = 'ul';
				} elseif($matches[1]=='+') {
					$block_type = 'ol';
				} elseif($matches[1]=='>') {
					$block_type = 'blockquote';
				}
				$buffer = "<$block_type$attributes>\n";
			}
			if($block_type=='table') {
				$buffer .= '<tr>';
				$columns = explode('|',substr($string,1,strlen($string)-2));
				foreach($columns as $data) {
					$buffer .= '<td>'.nano_wiki_inline_elements($data).'</td>';
				}
				$buffer .= '</tr>';
			} elseif($block_type=='ul' OR $block_type=='ol') {
				$buffer .= '<li>'.nano_wiki_inline_elements($matches[2])."</li>";
			} elseif($block_type=='blockquote') {
				$buffer .= nano_wiki_inline_elements($matches[2]);
			}
			$string = $buffer;
			$buffer = '';
		} elseif($block_type) {
			$buffer = nano_wiki_inline_elements($string);
			$string = "</$block_type>\n".$buffer;
			$block_type = $attributes = $buffer = '';
		// header
		} elseif(preg_match("/^\*.*/",$string)) {
			$string = preg_replace("/^\*\*\*(.*)$/","<$thirdry_header class=\"h3\">$1</$thirdry_header>",$string);
			$string = preg_replace("/^\*\*(.*)$/","<$secondry_header class=\"h2\">$1</$secondry_header>",$string);
			$string = preg_replace("/^\*(.*)$/","<$primary_header class=\"h1\">$1</$primary_header>",$string);
		} else {
			$string = nano_wiki_inline_elements($string);
		}
		
		// br
		if(substr($string,-1)!='>') {
			$string .= "<br />\n";
		} else {
			$string .= "\n";
		}
		
		$result .= $string;
	}
	return $result;
}

function nano_wiki_inline_elements($string) {
	// strong
	$string = preg_replace("/&strong\{(.*?)\}/",'<strong>$1</strong>',$string);
	// italic
	$string = preg_replace("/&i\{(.*?)\}/",'<i>$1</i>',$string);
	// bold
	$string = preg_replace("/&b\{(.*?)\}/",'<b>$1</b>',$string);
	// underline
	$string = preg_replace("/&ul\{(.*?)\}/",'<ins>$1</ins>',$string);
	// delete
	$string = preg_replace("/&del\{(.*?)\}/",'<del>$1</del>',$string);
	// sup
	$string = preg_replace("/&sup\{(.*?)\}/",'<sup>$1</sup>',$string);
	// sub
	$string = preg_replace("/&sub\{(.*?)\}/",'<sub>$1</sub>',$string);
	// color
	$string = preg_replace("/&color\((.*?),(.*?)\)\{(.*?)\}/",'<span style="color:$1;background-color:$2;">$3</span>',$string);
	$string = preg_replace("/&color\((.*?)\)\{(.*?)\}/",'<span style="color:$1;">$2</span>',$string);
	// Image
		
	if(preg_match("/&img\((.*?)\)/",$string,$matches)) {
		$attr = explode(',',$matches[1]);
		switch(count($attr)) {
			case '1': $tag = '<img src="'.$attr[0].'" />';
				break;
			case '2': $tag = '<img src="'.$attr[0].'" width="'.$attr[1].'" />';
				break;
			case '3': $tag = '<img src="'.$attr[0].'" width="'.$attr[1].'" height="'.$attr[2].'" />';
				break;
			case '4': $tag = '<img src="'.$attr[0].'" width="'.$attr[1].'" height="'.$attr[2].'" alt="'.$attr[3].'" />';
		}
		$string = preg_replace("/&img\(.*?\)/",$tag,$string);
	} else {
		$string = preg_replace("/(http:\/\/.+?)(\.gif|\.jpg|\.png)/",'<img src="$1$2" />',$string);
	}
	// URL link
	$string = preg_replace("/\[\[(.+?)>(http:\/\/.+?)\]\]/",'<a href="$2" target="_blank">$1</a>',$string);
	$string = preg_replace("/\[\[(.+?)>(.+?)\]\]/",'<a href="$2">$1</a>',$string);
	return $string;
}

/* vim: set expandtab: */

?>
