/*
QVanaClock -- Vana'diel Clock for Zaurus SL-C Series.
Copyright (C) 2004 Gussan(http://sourceforge.jp/users/gsn/)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// ܸʸɡܸEUC
#include <stdio.h>
#include "qvsguild.h"


QVSGuildCalc::QVSGuildCalc(QString& open_time, QString& close_time, int close_week)
{
    m_strOpenTime = open_time;
    m_strCloseTime = close_time;
    m_closeDayofWeek = close_week;

    m_status = -1;
    m_remainSec = -1;

}

/*
  ꥿
    0:֤ѹʤ
    1:ơѹ
*/
int QVSGuildCalc::setCurrentDateTime(QDateTime& curDT)
{
    long nextSec = curDT.secsTo(m_nextStatusDT);
    long prevSec = curDT.secsTo(m_prevStatusDT);
    if(prevSec < 0 && nextSec > 0){
      m_remainSec = curDT.secsTo(m_RemainDT);
      return 0;
    }

    m_currentDT = curDT;
    QVSDateTime vanaCurDT;
    vanaCurDT.setEarthDateTime(curDT);
    QVSDateTime workDT;
    //ٶξ
    if(vanaCurDT.vanaDayofWeek() == m_closeDayofWeek){
      m_status = 2;
      // Stat
      workDT.setVanaDateTime(vanaCurDT.vanaYear(),
                             vanaCurDT.vanaMonth(),
                             vanaCurDT.vanaDay() + 1,
                             0,
                             0,
                             0 );
      m_nextStatusDT = workDT.earthDT();
      workDT.setVanaDateTime(vanaCurDT.vanaYear(),
                             vanaCurDT.vanaMonth(),
                             vanaCurDT.vanaDay(),
                             0,
                             0,
                             0 );
      m_prevStatusDT = workDT.earthDT();
      // Remain
      workDT.setVanaDateTime(vanaCurDT.vanaYear(),
                             vanaCurDT.vanaMonth(),
                             vanaCurDT.vanaDay() + 1,
                             m_strOpenTime.mid(0,2).toInt(),
                             m_strOpenTime.mid(3,2).toInt(),
                             0 );
      m_RemainDT = workDT.earthDT();
      m_remainSec = curDT.secsTo(m_RemainDT);
      return 1;
    }

    QString strNextStatChangeTime;
    QString strPrevStatChangeTime;
    QString strRemainCalcTime;
    int statChangeDayOffset = 0;
    int remainCalcDayOffset = 0;
    QString strVanaCurTime;
    strVanaCurTime.sprintf("%02ld:%02ld",vanaCurDT.vanaHour(),vanaCurDT.vanaMinute());
    if( QString("00:00") <= strVanaCurTime && strVanaCurTime < m_strOpenTime ){
      m_status = 1; // Ź
      strNextStatChangeTime = m_strOpenTime;
      strPrevStatChangeTime = "00:00";
      statChangeDayOffset = 0;
      strRemainCalcTime = m_strOpenTime;
      remainCalcDayOffset = 0;
    }else if(m_strOpenTime <= strVanaCurTime && strVanaCurTime < m_strCloseTime){
      m_status = 0; // Ź
      strNextStatChangeTime = m_strCloseTime;
      strPrevStatChangeTime = m_strOpenTime;
      statChangeDayOffset = 0;
      strRemainCalcTime = m_strCloseTime;
      remainCalcDayOffset = 0;
    }else{ // Ź24:00
      m_status = 1; // Ź
      strNextStatChangeTime = "00:00";
      strPrevStatChangeTime = m_strCloseTime;
      statChangeDayOffset = 1;
      strRemainCalcTime = m_strOpenTime;
      // ٶ
      if(vanaCurDT.vanaDayofWeek()+1 == m_closeDayofWeek ||
         (vanaCurDT.vanaDayofWeek() == 7 && m_closeDayofWeek == 0) ){
        remainCalcDayOffset = 2;
      }else{
        remainCalcDayOffset = 1;
      }
    }
    // Stat
    workDT.setVanaDateTime(vanaCurDT.vanaYear(),
                           vanaCurDT.vanaMonth(),
                           vanaCurDT.vanaDay() + statChangeDayOffset,
                           strNextStatChangeTime.mid(0,2).toInt(),
                           strNextStatChangeTime.mid(3,2).toInt(),
                           0 );
    m_nextStatusDT = workDT.earthDT();
    workDT.setVanaDateTime(vanaCurDT.vanaYear(),
                           vanaCurDT.vanaMonth(),
                           vanaCurDT.vanaDay(),
                           strPrevStatChangeTime.mid(0,2).toInt(),
                           strPrevStatChangeTime.mid(3,2).toInt(),
                           0 );
    m_prevStatusDT = workDT.earthDT();
    // Remain
    workDT.setVanaDateTime(vanaCurDT.vanaYear(),
                           vanaCurDT.vanaMonth(),
                           vanaCurDT.vanaDay() + remainCalcDayOffset,
                           strRemainCalcTime.mid(0,2).toInt(),
                           strRemainCalcTime.mid(3,2).toInt(),
                           0 );
    m_RemainDT = workDT.earthDT();
    m_remainSec = curDT.secsTo(m_RemainDT);
    return 1;
}


// VanaWeekColor
QPalette QVSGuildItem::weekColor[8] =
          {QPalette(QColor(255, 64, 64)),
           QPalette(QColor(255,255, 64)),
           QPalette(QColor( 64,255,255)),
           QPalette(QColor(128,255,128)),
           QPalette(QColor(128,128,255)),
           QPalette(QColor(255, 96,255)),
           QPalette(QColor(255,255,255)),
           QPalette(QColor( 64, 64, 64))};
QString QVSGuildItem::weekName[8] =
          {QString(""),QString(""),
           QString(""),QString(""),
           QString("ɹ"),QString(""),
           QString(""),QString("")};

QVSGuildItem::QVSGuildItem(QString guild_name,
                           QString location,
                           QString start_time,
                           QString end_time,
                           int      close_dayofweek,
                           QWidget* parent) : QWidget(parent)
{

    m_pCalc = new QVSGuildCalc(start_time, end_time, close_dayofweek);

    QFont font;
    font.setPointSize(16);

    m_pNameBox = new QVBox(this);
    m_pNameBox->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    m_pNameBox->setLineWidth(2);
    m_pName = new QLabel(tr(guild_name), m_pNameBox);
    m_pName->setPalette(QPalette(QColor(255, 255, 255)));
    m_pName->setAlignment(AlignHCenter | AlignBottom);
    m_pLocation = new QLabel(tr(location), m_pNameBox);
    m_pLocation->setAlignment(AlignHCenter | AlignTop);
    m_pLocation->setPalette(QPalette(QColor(255, 255, 255)));
    font.setPointSize(8);
    m_pLocation->setFont(font);
    font.setPointSize(16);
    m_pStatus = new QLabel(m_pNameBox);
    m_pStatus->setAlignment(AlignHCenter | AlignVCenter);
    m_pStatus->setPalette(QPalette(QColor(255, 255, 255)));
    m_pStatus->setFont(font);

    m_pOpenTimeBox = new QHBox(this);
    m_pOpenTimeBox->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    m_pOpenTimeBox->setLineWidth(2);
    QString str;
    str.sprintf("%s-%s",start_time.latin1(),end_time.latin1());
    m_pOpenTimeCaption = new QLabel(tr(""), m_pOpenTimeBox);
    m_pOpenTimeCaption->setAlignment(AlignLeft | AlignTop);
    m_pOpenTimeCaption->setPalette(QPalette(QColor(255, 255, 255)));
    m_pOpenTimeCaption->setFont(font);
    m_pOpenTime = new QLabel(tr(str), m_pOpenTimeBox);
    m_pOpenTime->setAlignment(AlignLeft | AlignTop);
    m_pOpenTime->setPalette(QPalette(QColor(255, 255, 255)));
    m_pOpenTime->setFont(font);

    m_pCloseWeekBox = new QHBox(this);
    m_pCloseWeekBox->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    m_pCloseWeekBox->setLineWidth(2);
    m_pCloseWeekCaption = new QLabel(tr("ٶ"),m_pCloseWeekBox);
    m_pCloseWeekCaption->setAlignment(AlignLeft | AlignTop);
    m_pCloseWeekCaption->setPalette(QPalette(QColor(255, 255, 255)));
    m_pCloseWeekCaption->setFont(font);

    m_pCloseWeek = new QLabel(tr(weekName[close_dayofweek]),m_pCloseWeekBox);
    m_pCloseWeek->setAlignment(AlignHCenter | AlignTop);
    m_pCloseWeek->setPalette(weekColor[close_dayofweek]);
    m_pCloseWeek->setFont(font);

    m_pStatusBox = new QHBox(this);
    m_pStatusBox->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    m_pStatusBox->setLineWidth(2);
    m_pRemainCaption = new QLabel(m_pStatusBox);
    m_pRemainCaption->setAlignment(AlignLeft | AlignTop);
    m_pRemainCaption->setPalette(QPalette(QColor(255, 255, 255)));
    m_pRemainCaption->setFont(font);
    m_pRemainTime = new QLabel(m_pStatusBox);
    m_pRemainTime->setAlignment(AlignLeft | AlignTop);
    m_pRemainTime->setPalette(QPalette(QColor(255, 255, 255)));
    m_pRemainTime->setFont(font);

}

void QVSGuildItem::refresh(QDateTime& curDT)
{
    int changed = m_pCalc->setCurrentDateTime(curDT);

    QString strTime;
    strTime.sprintf("%02ld:%02ld", (m_pCalc->getRemainSec())/60, (m_pCalc->getRemainSec())%60);
    m_pRemainTime->setText(strTime);

    if(!changed) return;

    QPalette pal;
    switch(m_pCalc->getStatus()){
      case 0:
        m_pStatus->setText(tr("Ķ"));
        m_pRemainCaption->setText(tr("Źޤ"));

        pal = QPalette(QColor(255, 255, 255));
        m_pNameBox->setPalette(pal);
        m_pName->setPalette(pal);
        m_pStatus->setPalette(pal);
        m_pLocation->setPalette(pal);
        m_pOpenTimeBox->setPalette(pal);
        m_pOpenTimeCaption->setPalette(pal);
        m_pOpenTime->setPalette(pal);
        m_pCloseWeekBox->setPalette(pal);
        m_pCloseWeekCaption->setPalette(pal);
        m_pStatusBox->setPalette(pal);
        m_pRemainCaption->setPalette(pal);
        m_pRemainTime->setPalette(pal);

        break;
      case 1:
      case 2:
        if((m_pCalc->getStatus()) == 1){
          m_pStatus->setText(tr("Ź"));
        }else{
          m_pStatus->setText(tr("ٶ"));
        }
        m_pRemainCaption->setText(tr("Źޤ"));

        pal = QPalette(QColor(150, 150, 150));
        m_pNameBox->setPalette(pal);
        m_pName->setPalette(pal);
        m_pStatus->setPalette(pal);
        m_pLocation->setPalette(pal);
        m_pOpenTimeBox->setPalette(pal);
        m_pOpenTimeCaption->setPalette(pal);
        m_pOpenTime->setPalette(pal);
        m_pCloseWeekBox->setPalette(pal);
        m_pCloseWeekCaption->setPalette(pal);
        m_pStatusBox->setPalette(pal);
        m_pRemainCaption->setPalette(pal);
        m_pRemainTime->setPalette(pal);

        break;
    }
}
void QVSGuildItem::resizeLayout(int mode)
{

    if(mode == 0){
      m_pNameBox->setGeometry(0,0,96,62);
      m_pName->setFixedSize(92,26);
      m_pLocation->setFixedSize(92,12);
      m_pStatus->setFixedSize(92,20);

      m_pOpenTimeBox->setGeometry(97,0,111,20);
      m_pOpenTimeCaption->setFixedSize(18,16);
      m_pOpenTime->setFixedSize(89,16);

      m_pCloseWeekBox->setGeometry(97,21,111,20);
      m_pCloseWeekCaption->setFixedSize(51,16);
      m_pCloseWeek->setFixedSize(56,16);

      m_pStatusBox->setGeometry(97,42,111,20);
      m_pRemainCaption->setFixedSize(65,16);
      m_pRemainTime->setFixedSize(42,16);
    }else{
      m_pNameBox->setGeometry(0,0,108,62);
      m_pName->setFixedSize(104,26);
      m_pLocation->setFixedSize(104,12);
      m_pStatus->setFixedSize(104,20);

      m_pOpenTimeBox->setGeometry(109,0,120,20);
      m_pOpenTimeCaption->setFixedSize(18,16);
      m_pOpenTime->setFixedSize(98,16);

      m_pCloseWeekBox->setGeometry(109,21,120,20);
      m_pCloseWeekCaption->setFixedSize(56,16);
      m_pCloseWeek->setFixedSize(60,16);

      m_pStatusBox->setGeometry(109,42,120,20);
      m_pRemainCaption->setFixedSize(65,16);
      m_pRemainTime->setFixedSize(51,16);
    }
}

QVSGuild::QVSGuild(QWidget* parent):QWidget(parent)
{
    m_pGuildItem[0] = new QVSGuildItem(QString(""),QString("C8"),QString("03:00"),QString("18:00"),5,this);
    m_pGuildItem[1] = new QVSGuildItem(QString("()"),QString(""),QString("01:00"),QString("23:00"),5,this);
    m_pGuildItem[2] = new QVSGuildItem(QString("ڹ"),QString("E3"),QString("06:00"),QString("21:00"),0,this);
    m_pGuildItem[3] = new QVSGuildItem(QString(""),QString("E5/F7/G9"),QString("08:00"),QString("23:00"),2,this);
    m_pGuildItem[4] = new QVSGuildItem(QString("Ħ"),QString("оH8/G8"),QString("08:00"),QString("23:00"),4,this);
    m_pGuildItem[5] = new QVSGuildItem(QString(""),QString("G12/I9"),QString("06:00"),QString("21:00"),0,this);
    m_pGuildItem[6] = new QVSGuildItem(QString("׹"),QString("D8"),QString("03:00"),QString("18:00"),4,this);
    m_pGuildItem[7] = new QVSGuildItem(QString(""),QString("H12"),QString("08:00"),QString("23:00"),3,this);
    m_pGuildItem[8] = new QVSGuildItem(QString("ϣ"),QString("йK7"),QString("08:00"),QString("23:00"),6,this);
    m_pGuildItem[9] = new QVSGuildItem(QString("Ĵ"),QString("()E9"),QString("05:00"),QString("20:00"),7,this);

}
void QVSGuild::refresh()
{
    // ߻
    QDateTime curDT = QDateTime::currentDateTime();
    for(int i = 0; i <= 9; i++){
      m_pGuildItem[i]->refresh(curDT);
    }
}
void QVSGuild::resizeLayout(int mode)
{
    if(mode == 0){
      for(int i = 0; i <= 9; i++){
//printf("%i,%i\n",(i/3)*213,(i%3)*65);
        m_pGuildItem[i]->setGeometry(2+(i%3)*212,4+(i/3)*65,211,62);
        m_pGuildItem[i]->resizeLayout(mode);
      }
    }else{
      for(int i = 0; i <= 9; i++){
        m_pGuildItem[i]->setGeometry(4+(i%2)*235,10+(i/2)*68,233,62);
        m_pGuildItem[i]->resizeLayout(mode);
      }
    }
}

