/*
QVanaClock -- Vana'diel Clock for Zaurus SL-C Series.
Copyright (C) 2004 Gussan(http://sourceforge.jp/users/gsn/)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdlib.h>

#include <qstring.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qlabel.h> 
#include <qcombobox.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qgrid.h>
#include <qlayout.h>
#include <qdatetime.h>
#include <qfont.h>
#include <qpalette.h>
#include <qcolor.h>
#include <qtimer.h>
#include <qevent.h>
#include <qvalidator.h>
#include <qmessagebox.h>
#include <qsound.h>
#include <qtextcodec.h>
#include <qtabwidget.h>
#include "qvssaverctl.h"

#ifndef QVSTIMER_H
#define QVSTIMER_H

class QVSStartButton :public QPushButton
{
    Q_OBJECT
  private:
    QString m_strHotkey;

  public:
    QVSStartButton(QWidget* parent, QString hotkey);
    void buttonNameChange(int fStatus);
};

class QVSResetButton : public QPushButton
{
    Q_OBJECT
  public:
    QVSResetButton(QWidget* parent);
    void buttonNameChange(int fStatus);
};

class QVSForRewButton : public QPushButton
{
    Q_OBJECT
  public:
    QVSForRewButton(QWidget* parent, QString caption);
};

class QVSTimeDisp : public QLabel
{
    Q_OBJECT
  public:
    QVSTimeDisp(QWidget* parent);

  public slots:
    void display(long iTime);
    void display_initial();
};


class QVSTimeSelect : public QComboBox
{
    Q_OBJECT
  private:
    QIntValidator* m_pIntValid;
  public:
    QVSTimeSelect(QWidget* parent);
    long getTime();
    void keyReleaseEvent ( QKeyEvent * e );
};


class QVSTimerItem : public QVBox
{
    Q_OBJECT
  private:
    int m_status;

    QHBox* m_pHbox1;
    QVSTimeDisp* m_pTimedisp;
    QVSForRewButton* m_pRewbutton;
    QVSForRewButton* m_pForbutton;
    QVSStartButton*  m_pSbutton;

    QHBox* m_pHbox2;
    QVSTimeSelect*  m_pTcombo;
    QVSResetButton* m_pRbutton;

    QDateTime m_StartTime;
    long m_setTime;
    long m_userSetTime;
    long m_remainTime;

    QString m_strAcclKey;

  public:
    QVSTimerItem(QWidget* pObj, QString hotkey);
    ~QVSTimerItem();
    QString getAcclKey() { return m_strAcclKey;};
    void Reset();
    void refresh();
    int isRunning();
    void setItemFocus();

  public slots:
    void handleStart();
    void handleReset();
    void handleRewind();
    void handleForward();

  signals:
    void statusChanged();

};

class QVSTimerWindow : public QGrid, public QVSRunning
{
    Q_OBJECT
  private:
    QVSTimerItem* m_pTimerItem[6];
  public:
    QVSTimerWindow(QWidget* parent);
    void keyReleaseEvent ( QKeyEvent * e );
    void refresh();
    int isRunning();
  public slots:
    void handleStatusChanged();
  signals:
    void statusChanged();
};

#endif //QVSTIMER_H
