/*
QVanaClock -- Vana'diel Clock for Zaurus SL-C Series.
Copyright (C) 2004 Gussan(http://sourceforge.jp/users/gsn/)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include "qvsclock.h"

QVSLabelWithSub::QVSLabelWithSub(QString text, QWidget* parent):QHBox(parent)
{
    m_pSubLStr = new QLabel(this);
    m_pMainStr = new QLabel(this);
    m_pSubRStr = new QLabel(this);

    QFont strSubFont;
    strSubFont.setPointSize(8);
    m_pSubLStr->setFixedWidth(12);
    m_pSubLStr->setFont(strSubFont);
    m_pSubRStr->setFixedWidth(12);
    m_pSubRStr->setFont(strSubFont);
    m_pSubLStr->setAlignment(AlignHCenter);

    QFont strMainFont;
    strMainFont.setPointSize(20);
    m_pMainStr->setFont(strMainFont);
    m_pMainStr->setAlignment(AlignHCenter);
    m_pMainStr->setText(tr(text));

}

void QVSLabelWithSub::setWidth(long width)
{
    setFixedWidth(width);
}
void QVSLabelWithSub::setPalette(QPalette palette)
{
    m_pMainStr->setPalette(palette);
    m_pSubLStr->setPalette(palette);
    m_pSubRStr->setPalette(palette);
}

void QVSLabelWithSub::setMainText(QString text)
{
    m_pMainStr->setText(tr(text));
}

void QVSLabelWithSub::setSubLText(QString text)
{
    m_pSubLStr->setText(tr(text));
}

void QVSLabelWithSub::setSubRText(QString text)
{
    m_pSubRStr->setText(tr(text));
}


QVSClock::QVSClock(QWidget* parent):QWidget(parent)
{
    m_resizeAccept = 0;

    // VanaClock(Text)
    m_pVanaCaption   = new QLabel("Vana'diel", this);
    m_pVanaClockText = new QLabel(this);
    m_pVanaMoonText  = new QLabel(this);

    m_pVanaCaption->setFixedWidth(100);
    m_pVanaCaption->setAlignment(AlignHCenter);

    QFont newFont;
    newFont.setPointSize(20);
    m_pVanaCaption->setFont(newFont);
    newFont.setPointSize(24);
    m_pVanaClockText->setFont(newFont);
    newFont.setPointSize(20);
    m_pVanaMoonText->setFont(newFont);


    // VanaWeek
    m_weekColor[0] = QPalette(QColor(255, 64, 64));
    m_weekColor[1] = QPalette(QColor(255,255, 64));
    m_weekColor[2] = QPalette(QColor( 64,255,255));
    m_weekColor[3] = QPalette(QColor(128,255,128));
    m_weekColor[4] = QPalette(QColor(128,128,255));
    m_weekColor[5] = QPalette(QColor(255, 96,255));
    m_weekColor[6] = QPalette(QColor(255,255,255));
    m_weekColor[7] = QPalette(QColor( 64, 64, 64));

    QColorGroup weekInactColGrp;
    weekInactColGrp.setColor(QColorGroup::Foreground, QColor(128,128,128));
    weekInactColGrp.setColor(QColorGroup::Background, QColor(255,255,255));
    m_weekColorInact = QPalette(weekInactColGrp,weekInactColGrp,weekInactColGrp);

    for(int i = 0; i < 8; i++){
      m_pWeekLabel[i] = new QVSLabelWithSub(QVSDateTime::VanaWeekList[i],this);
    }


    // VanaMoon
    m_moonColorAct = QPalette(QColor(255,255,150));
    QColorGroup moonInactColGrp;
    moonInactColGrp.setColor(QColorGroup::Foreground, QColor(128,128,128));
    moonInactColGrp.setColor(QColorGroup::Background, QColor(255,255,255));
    m_moonColorInact = QPalette(moonInactColGrp,moonInactColGrp,moonInactColGrp);

    newFont.setPointSize(16);
    for(int i = 0; i < 12; i++){
      m_pMoonLabel[i] = new QLabel(tr(QVSDateTime::VanaMoonList[i]),this);
      m_pMoonLabel[i]->setFont(newFont);
      m_pMoonLabel[i]->setAlignment(AlignHCenter);
    }

    // EarthClock(Text)
    m_pEarthCaption   = new QLabel("Earth", this);
    m_pEarthClockText = new QLabel(this);

    m_pEarthCaption->setFixedWidth(100);
    m_pEarthCaption->setAlignment(AlignHCenter);

    newFont.setPointSize(20);
    m_pEarthCaption->setFont(newFont);
    newFont.setPointSize(20);
    m_pEarthClockText->setFont(newFont);

    // EarthClock(US)
    const int TZNUM = 5;
    TimeZoneName[0]   = tr("쳤DST");
    TimeZoneOffset[0] = -14;
    TimeZoneDST[0]    = 1;
    TimeZoneName[1]   = tr("DST");
    TimeZoneOffset[1] = -15;
    TimeZoneDST[1]    = 1;
    TimeZoneName[2]   = tr("DST");
    TimeZoneOffset[2] = -16;
    TimeZoneDST[2]    = 1;
    TimeZoneName[3]   = tr("ʿDST");
    TimeZoneOffset[3] = -17;
    TimeZoneDST[3]    = 1;
/* //4ʸϤΤǥå
    TimeZoneName[4]   = tr("饹");
    TimeZoneOffset[4] = -18;
    TimeZoneDST[4]    = 0;
*/
    TimeZoneName[4]   = tr("ϥ磻");
    TimeZoneOffset[4] = -19;
    TimeZoneDST[4]    = 0;
/*
    TimeZoneName[6]   = tr("쳤");
    TimeZoneOffset[6] = -14;
    TimeZoneDST[6]    = 0;
    TimeZoneName[7]   = tr("");
    TimeZoneOffset[7] = -15;
    TimeZoneDST[7]    = 0;
    TimeZoneName[8]   = tr("");
    TimeZoneOffset[8] = -16;
    TimeZoneDST[8]    = 0;
    TimeZoneName[9]   = tr("ʿ");
    TimeZoneOffset[9] = -17;
    TimeZoneDST[9]    = 0;
*/
    m_pUSTimeZone = new QComboBox(this);
    m_pUSTimeZone->setEditable(FALSE);
    m_pUSTimeZone->setDuplicatesEnabled(FALSE);
    newFont.setPointSize(16);
    m_pUSTimeZone->setFont(newFont);
    for(int i = 0; i < TZNUM; i++){
      m_pUSTimeZone->insertItem(TimeZoneName[i]);
    }
    m_pEarthClockTextUS = new QLabel(this);
    newFont.setPointSize(20);
    m_pEarthClockTextUS->setFont(newFont);

    // Others
    m_currentVanaDate = 0;
    m_curYear = 0;

//    resizeLayout(0);
//    handleRefresh();

    m_resizeAccept = 1;

    connect(m_pUSTimeZone, SIGNAL(activated(int)), this, SLOT(handleTZChanged(int)));

}

void QVSClock::handleRefresh()
{
    QDateTime curdt(QDateTime::currentDateTime());
    if(curdt.time().second() == m_currentDT.earthDT().time().second()){
      return;
    }

    m_currentDT.setEarthDateTime(curdt);

    QString vanaClockStr;
    QString vanaMoonStr;
    QString earthStr;
    vanaClockStr.sprintf("%04ld/%02ld/%02ld(%s) %02ld:%02ld",
                     m_currentDT.vanaYear(),m_currentDT.vanaMonth(),m_currentDT.vanaDay(),
                     (const char*)(m_currentDT.vanaDayofWeekStr().utf8()),
                     m_currentDT.vanaHour(),m_currentDT.vanaMinute());

    vanaMoonStr.sprintf(" <%s(%ld/7)>",
                     (const char*)(m_currentDT.vanaMoonStr().utf8()),m_currentDT.vanaDayofMoon());
//                     (const char*)(QString(";").utf8()),m_currentDT.vanaDayofMoon());

    earthStr.sprintf("%04d/%02d/%02d(%s) %02d:%02d:%02d",
                     curdt.date().year(),curdt.date().month(),curdt.date().day(),
                     QVSDateTime::EarthWeekList[curdt.date().dayOfWeek()-1].latin1(),
                     curdt.time().hour(),curdt.time().minute(),curdt.time().second());

    m_pVanaClockText->setText(tr(vanaClockStr));
    m_pVanaMoonText->setText(tr(vanaMoonStr));
    m_pEarthClockText->setText(earthStr);

    // US
    m_pEarthClockTextUS->setText(getUSDateTimeStr());

    // VanaդƱʤ饹å
    if(m_currentVanaDate == m_currentDT.vanaDay()){
      return;
    }
    m_currentVanaDate = m_currentDT.vanaDay();

    // Vana
    for(int i = 0; i < 8; i++){
      if(i == m_currentDT.vanaDayofWeek()){
        m_pWeekLabel[i]->setPalette(m_weekColor[i]);
        m_pWeekLabel[i]->setSubLText("\n");
      }else if(i == m_currentDT.vanaWEAKWeek()){
//        m_pWeekLabel[i]->setPalette(m_weekColorWeak);
        m_pWeekLabel[i]->setPalette(m_weekColor[i]);
        m_pWeekLabel[i]->setSubLText("");
      }else{
        m_pWeekLabel[i]->setPalette(m_weekColorInact);
        m_pWeekLabel[i]->setSubLText(tr(""));
      }

    }

    // Vana
    for(int i = 0; i < 12; i++){
      if(i == m_currentDT.vanaMoon()){
        m_pMoonLabel[i]->setPalette(m_moonColorAct);
      }else{
        m_pMoonLabel[i]->setPalette(m_moonColorInact);
      }
    }

}

QDateTime QVSClock::getDstStart(long year)
{
    //4ǽˤ
    QDate date;
    for(long day = 1; day <= 7; day++){
      date.setYMD(year,4,day);
      if(date.dayOfWeek()==7){
        break;
      }
    }
    QTime time(2,0,0);  //2:00ڤؤ
    return QDateTime(date,time);
}

QDateTime QVSClock::getDstEnd(long year)
{
    //10Ǹˤ
    QDate date;
    for(long day = 31; day >= 25; day--){
      date.setYMD(year,10,day);
      if(date.dayOfWeek()==7){
        break;
      }
    }
    QTime time(2,0,0);  //2:00ڤؤ
    return QDateTime(date,time);
}

QString QVSClock::getUSDateTimeStr()
{
    if(m_curYear != m_currentDT.earthDT().date().year()){
      long year = m_currentDT.earthDT().date().year();
      m_DstStartDT = getDstStart(year);
      m_DstEndDT   = getDstEnd(year);
      m_curYear = year;
    }
    int curTZ = m_pUSTimeZone->currentItem();

    QDateTime curUSDT;
    curUSDT = m_currentDT.earthDT().addSecs(TimeZoneOffset[curTZ] * 60 * 60);

    // DST
/*
printf("st:%s\nen:%s\ncu:%s\n",
m_DstStartDT.toString().latin1(),
m_DstEndDT.toString().latin1(),
curUSDT.toString().latin1());
*/
    if(TimeZoneDST[curTZ]){
      if(m_DstStartDT <= curUSDT && curUSDT < m_DstEndDT){
        curUSDT = curUSDT.addSecs(60*60);
      }
    }

    QString earthUSStr;
    earthUSStr.sprintf("%02d/%02d(%s)%02d:%02d:%02d",
                     curUSDT.date().month(),curUSDT.date().day(),
                     QVSDateTime::EarthWeekList[curUSDT.date().dayOfWeek()-1].latin1(),
                     curUSDT.time().hour(),curUSDT.time().minute(),curUSDT.time().second());
    return earthUSStr;
}

void QVSClock::handleTZChanged(int index)
{
    m_pEarthClockTextUS->setText(getUSDateTimeStr());
}

void QVSClock::resizeLayout(int mode)
{

//printf("resizeLayout(%d), resizeAccept(%d)\n",mode,m_resizeAccept);

    if(!m_resizeAccept) return;

    if(mode==0){

      // Υ
      setFixedSize(640,130);

      //earth
      m_pEarthCaption->setGeometry(15,3,85,22);
      m_pEarthClockText->setGeometry(105,3,270,22);
      m_pUSTimeZone->setGeometry(360,0,93,29);
      m_pEarthClockTextUS->setGeometry(455,3,185,22);

      //vana
      m_pVanaCaption->setGeometry(2,31,97,22);
      m_pVanaClockText->setGeometry(105,26,240,30);
      m_pVanaMoonText->setGeometry(350,26,285,30);

      //week
      for(int i = 0; i < 8; i++){
        m_pWeekLabel[i]->setWidth(64);
        m_pWeekLabel[i]->setGeometry(110+i*66,56,64,22);
      }

      //moon
      for(int i = 0; i < 2; i++){
        for(int j = 0; j < 6; j++){
          m_pMoonLabel[i*6+j]->setFixedSize(85,18);
          m_pMoonLabel[i*6+j]->setGeometry(110+j*87,81+i*20,84,18);
        }
      }

    }else if(mode==1){

      QFont newFont;

      // Υ
      setFixedSize(480,198);

      //earth
      m_pEarthCaption->setGeometry(3,3,100,22);
      m_pEarthClockText->setGeometry(102,3,270,22);
      m_pUSTimeZone->setGeometry(102,25,93,29);
      m_pEarthClockTextUS->setGeometry(197,27,200,22);

      //text
      m_pVanaCaption->setGeometry(2,59,100,22);
      m_pVanaClockText->setGeometry(102,53,240,32);
      m_pVanaMoonText->setGeometry(104,80,285,30);

      //week
      for(int i = 0; i < 8; i++){
        m_pWeekLabel[i]->setWidth(44);
        m_pWeekLabel[i]->setGeometry(102+i*47,110,44,22);
      }

      //moon
      for(int i = 0; i < 3; i++){
        for(int j = 0; j < 4; j++){
          m_pMoonLabel[i*4+j]->setFixedSize(90,18);
          m_pMoonLabel[i*4+j]->setGeometry(102+j*93,135+i*20,90,18);
        }
      }

    }

}

