/*
QVanaClock -- Vana'diel Clock for Zaurus SL-C Series.
Copyright (C) 2004 Gussan(http://sourceforge.jp/users/gsn/)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <qpe/qpeapplication.h>
#include <qrect.h>

#include "qvssaverctl.h"

#include <stdio.h>

#define QVS_SCREENSAVER_STOP   2
#define QVS_SCREENSAVER_ACTIVE 3

void QVSScreenSaverCtl::setScreenSaverMode(int mode)
{
    // 1:ȥڥ̵  1or2:ͭ ڥ̵  3:ȥڥͭ
    QCopEnvelope e(QCString("QPE/System"), QCString("setScreenSaverMode(int)"));
    e << mode;

    m_lastMode = mode;

    // Τ٤NG
    //char str[50];
    //printf(str, "qcop QPE/System 'setScreenSaverMode(int)' %d", mode);
    //system(str);
}

QVSScreenSaverCtl::QVSScreenSaverCtl(QObject* parent):QObject(parent)
{
    m_lastMode = QVS_SCREENSAVER_ACTIVE;
    m_RunningObj = NULL;
}

QVSScreenSaverCtl::~QVSScreenSaverCtl()
{
}
void QVSScreenSaverCtl::setRunningObj(QVSRunning* obj)
{
    m_RunningObj = obj;
}

void QVSScreenSaverCtl::handleSetSaver()
{
    if(m_RunningObj == NULL) return;

    if(m_RunningObj->isRunning()){
      QVSScreenSaverCtl::setScreenSaverMode(QVS_SCREENSAVER_STOP);
      m_lastMode = QVS_SCREENSAVER_STOP;
    }else{
      if(m_lastMode != QVS_SCREENSAVER_ACTIVE){
        QVSScreenSaverCtl::setScreenSaverMode(QVS_SCREENSAVER_ACTIVE);
        m_lastMode = QVS_SCREENSAVER_ACTIVE;
      }
    }
}
