/*
QVanaClock -- Vana'diel Clock for Zaurus SL-C Series.
Copyright (C) 2004 Gussan(http://sourceforge.jp/users/gsn/)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// ܸʸɡܸEUC
#include <stdio.h>
#include "qvsship.h"

// ȯ
QString QVSShipTimeData::ArrivalJ2S[4] = {"00:13","06:13","12:13","18:13"};
QString QVSShipTimeData::ArrivalJ2B[4] = {"21:13","03:13","09:13","15:13"};
QString QVSShipTimeData::ArrivalJ2W[4] = {"01:43","07:43","13:43","19:43"};
QString QVSShipTimeData::ArrivalJ2K[4] = {"22:43","04:43","10:43","16:43"};
QString QVSShipTimeData::DepartureJ2S[4] = {"01:13","07:13","13:13","19:13"};
QString QVSShipTimeData::DepartureJ2B[4] = {"22:13","04:13","10:13","16:13"};
QString QVSShipTimeData::DepartureJ2W[4] = {"02:43","08:43","14:43","20:43"};
QString QVSShipTimeData::DepartureJ2K[4] = {"23:43","05:43","11:43","17:43"};
QString QVSShipTimeData::ArrivDestJ2S[4] = {"03:13","09:13","15:13","21:13"};
QString QVSShipTimeData::ArrivDestJ2B[4] = {"00:13","06:13","12:13","18:13"};
QString QVSShipTimeData::ArrivDestJ2W[4] = {"04:43","10:43","16:43","22:43"};
QString QVSShipTimeData::ArrivDestJ2K[4] = {"01:43","07:43","13:43","19:43"};
QString QVSShipTimeData::DepartureDispJ2S[4] = {"01:10","07:10","13:10","19:10"};
QString QVSShipTimeData::DepartureDispJ2B[4] = {"22:10","04:10","10:10","16:10"};
QString QVSShipTimeData::DepartureDispJ2W[4] = {"02:40","08:40","14:40","20:40"};
QString QVSShipTimeData::DepartureDispJ2K[4] = {"23:40","05:40","11:40","17:40"};

//ιԤ
QString QVSShipTimeData::ArrivalS2J[4] = {"21:13","03:13","09:13","15:13"};
QString QVSShipTimeData::ArrivalB2J[4] = {"00:13","06:13","12:13","18:13"};
QString QVSShipTimeData::ArrivalW2J[4] = {"22:43","04:43","10:43","16:43"};
QString QVSShipTimeData::ArrivalK2J[4] = {"01:43","07:43","13:43","19:43"};
QString QVSShipTimeData::DepartureS2J[4] = {"22:13","04:13","10:13","16:13"};
QString QVSShipTimeData::DepartureB2J[4] = {"01:13","07:13","13:13","19:13"};
QString QVSShipTimeData::DepartureW2J[4] = {"23:43","05:43","11:43","17:43"};
QString QVSShipTimeData::DepartureK2J[4] = {"02:43","08:43","14:43","20:43"};
QString QVSShipTimeData::ArrivDestS2J[4] = {"00:13","06:13","12:13","18:13"};
QString QVSShipTimeData::ArrivDestB2J[4] = {"03:13","09:13","15:13","21:13"};
QString QVSShipTimeData::ArrivDestW2J[4] = {"01:43","07:43","13:43","19:43"};
QString QVSShipTimeData::ArrivDestK2J[4] = {"04:43","10:43","16:43","22:43"};
QString QVSShipTimeData::DepartureDispS2J[4] = {"22:10","04:10","10:10","16:10"};
QString QVSShipTimeData::DepartureDispB2J[4] = {"01:10","07:10","13:10","19:10"};
QString QVSShipTimeData::DepartureDispW2J[4] = {"23:40","05:40","11:40","17:40"};
QString QVSShipTimeData::DepartureDispK2J[4] = {"02:40","08:40","14:40","20:40"};

QString QVSShipTimeData::ArrivalSM[3] = {"23:00","07:00","15:00"};
QString QVSShipTimeData::DepartureSM[3] = {"00:00","08:00","16:00"};
QString QVSShipTimeData::ArrivDestSM[3] = {"07:00","15:00","23:00"};

QString QVSShipTimeTable::m_strOrder[4] = {"ҹ","ȯ1","ȯ2","ȯ3"};

QVSShipTimeCalc::QVSShipTimeCalc(int scheduleNum,
                           QString* arrival,
                           QString* departure,
                           QString* arrivedist,
                           QString* departureDisp,
                           int listMax)
{
    m_scheduleNum = scheduleNum;
    m_scheduleArrival = arrival;
    m_scheduleDeparture = departure;
    m_scheduleArrivedist = arrivedist;
    m_scheduleDepartureDisp = departureDisp;
    m_listMax = listMax;
    earthDTScheduleArrival = new QDateTime[listMax];
    earthDTScheduleDeparture = new QDateTime[listMax];
    earthDTScheduleArrivedist = new QDateTime[listMax];
    //m_earthDTSchedule = new QDateTime[listMax];
    m_status = new int[listMax];
    for(int i = 0; i < listMax; i++){
      m_status[i] = 0;
    }
    m_strSchedule = new QString[listMax];
}

/*
  ꥿
    0:֤ѹʤ
    1:ѹ(Τ߽)
    2:ơѹ()
    ʥꥹƬؤˤꥹȤؤ⤢
*/
int QVSShipTimeCalc::setCurrentDateTime(QDateTime& curDT)
{
    // ðʲξ
    long curSecsTo = abs(m_currentDT.secsTo(curDT));
    if(curSecsTo < 1){
      return 0;
    }
    m_currentDT = curDT;
    // ߥơΥå
    //   ѲʤлĤѹΤ
    //   Ѳ񴹤ˤ
    int statusChanged = 0;
    if(curSecsTo > 10){
      // ʤ10ðʾ庹Ф
      statusChanged = 1;
    }else{
      for(int i = 0; i < m_listMax; i++){
        switch(m_status[i]){
          case 1: // StatԤ
            if(m_currentDT <  earthDTScheduleArrival[i] ){
              // ϰǥơѹʤ
            }else{
              statusChanged = 1;
            }
            break;
          case 2: // StatȯԤ
            if(m_currentDT >= earthDTScheduleArrival[i] &&
              m_currentDT <  earthDTScheduleDeparture[i]){
              // ϰǥơѹʤ
            }else{
              statusChanged = 1;
            }
            break;
          case 3: // StatԤ
            if(m_currentDT >= earthDTScheduleDeparture[i] &&
              m_currentDT <  earthDTScheduleArrivedist[i]){
              // ϰǥơѹʤ
            }else{
              statusChanged = 1;
            }
            break;
          default:
            statusChanged = 1;
            break;
        }
      }
    }
    if(statusChanged == 0){
      return 1;
    }

    //
    // ɽƷ׻
    //
    QVSDateTime vanaCurDT;
    vanaCurDT.setEarthDateTime(curDT);
    QString strVanaCurTime;
    strVanaCurTime.sprintf("%02ld:%02ld",vanaCurDT.vanaHour(),vanaCurDT.vanaMinute());

    int curSchedulePos = -1;
    QString cur,prev;
    for(int i = 0; i <= m_scheduleNum; i++){
      if(i == 0){
        cur = m_scheduleArrivedist[0];
        prev = "00:00";
      }else if(i == m_scheduleNum){
        prev = m_scheduleArrivedist[m_scheduleNum-1];
        cur = "24:00";
      }else{
        cur = m_scheduleArrivedist[i];
        prev = m_scheduleArrivedist[i-1];
      }
      // xx:xxηʸ
      if(strVanaCurTime>=prev && strVanaCurTime<cur){
        curSchedulePos = i;
        if(i >= m_scheduleNum){
          curSchedulePos = 0;
        }
        break;
      }
    }

    int spos = curSchedulePos;
    for(int i = 0; i < m_listMax; i++){
      long VanaDayOffsetArrival    = 0;//ޤǻȤ
      long VanaDayOffsetDeparture  = 0;//ޤǻȤ
      long VanaDayOffsetArrivedist = 0;//ޤǻȤ
      QVSDateTime workVDT;

      // Offset
      //  Arrive(=0)ǤäOffset
      if(m_scheduleArrival[spos] > m_scheduleDeparture[spos]){
        VanaDayOffsetDeparture = 1;
      }
      if(m_scheduleArrival[spos] > m_scheduleArrivedist[spos]){
        VanaDayOffsetArrivedist = 1;
      }

      // ߻Arrive()Ӥoffset
      // ߻Arriveδ֤ޤ꤬뤫θ
      if(m_scheduleArrival[spos] <= m_scheduleArrivedist[spos]){
        // ޤ arrive  or ޤʤ
        if(strVanaCurTime < m_scheduleArrival[spos]){
          // cur....arr...
        }else if(strVanaCurTime > m_scheduleArrivedist[spos]){
          // cur..(ޤ)..arr...
          VanaDayOffsetArrival++;
          VanaDayOffsetDeparture++;
          VanaDayOffsetArrivedist++;
        }
      }else{
        // arrarrdstδ֤ޤ
        if(strVanaCurTime > m_scheduleArrival[spos]){
          // arr....cur..(ޤ)..arrdst
          // NOP
        }else if(strVanaCurTime < m_scheduleArrivedist[spos]){
          // arr..(ޤ)..cur....arrdst
          VanaDayOffsetArrival--;
          VanaDayOffsetDeparture--;
          VanaDayOffsetArrivedist--;
        }
      }
/*
printf("cur:%s arr:%s dep:%s ard:%s  A:%d D:%d AD:%d\n",
strVanaCurTime.latin1(), m_scheduleArrival[spos].latin1(),
m_scheduleDeparture[spos].latin1(), m_scheduleArrivedist[spos].latin1(),
VanaDayOffsetArrival,VanaDayOffsetDeparture,VanaDayOffsetArrivedist);
*/
      // ArriveDist
      workVDT.setVanaDateTime(vanaCurDT.vanaYear(),
                             vanaCurDT.vanaMonth(),
                             vanaCurDT.vanaDay() + VanaDayOffsetArrivedist,
                             (long)(m_scheduleArrivedist[spos].mid(0,2).toInt()),
                             (long)(m_scheduleArrivedist[spos].mid(3,2).toInt()),
                             (long)0 );
      earthDTScheduleArrivedist[i] = workVDT.earthDT();

      // Departure
      workVDT.setVanaDateTime(vanaCurDT.vanaYear(),
                             vanaCurDT.vanaMonth(),
                             vanaCurDT.vanaDay() + VanaDayOffsetDeparture,
                             (long)(m_scheduleDeparture[spos].mid(0,2).toInt()),
                             (long)(m_scheduleDeparture[spos].mid(3,2).toInt()),
                             (long)0 );
      earthDTScheduleDeparture[i] = workVDT.earthDT();
      m_strSchedule[i] = m_scheduleDepartureDisp[spos];

      // Arrival
      workVDT.setVanaDateTime(vanaCurDT.vanaYear(),
                             vanaCurDT.vanaMonth(),
                             vanaCurDT.vanaDay() + VanaDayOffsetArrival,
                             (long)(m_scheduleArrival[spos].mid(0,2).toInt()),
                             (long)(m_scheduleArrival[spos].mid(3,2).toInt()),
                             (long)0 );
      earthDTScheduleArrival[i] = workVDT.earthDT();

      spos++;
      if(spos >= m_scheduleNum){
        spos = 0;
      }
    }
    for(int i = 0; i < m_listMax; i++){
      if(m_currentDT <  earthDTScheduleArrival[i] ){
        m_status[i] = 1;  // Ԥ
      }else if(m_currentDT >= earthDTScheduleArrival[i] &&
               m_currentDT <  earthDTScheduleDeparture[i]){
        m_status[i] = 2;  // ȯԤ
      }else if(m_currentDT >= earthDTScheduleDeparture[i] &&
               m_currentDT <  earthDTScheduleArrivedist[i]){
        m_status[i] = 3;  // Ԥ
      }
/*
printf("st:%d,\ncur:%s,\nArr:%s,\nDpt:%s,\nArD:%s\n",
m_status[i],
m_currentDT.toString().latin1(),
//earthDTSchedulePrevArrivedist[i].toString().latin1(),
earthDTScheduleArrival[i].toString().latin1(),
earthDTScheduleDeparture[i].toString().latin1(),
earthDTScheduleArrivedist[i].toString().latin1());
*/
    }
    return 2;
}

long QVSShipTimeCalc::getRemainSec(int listIndex)
{
    switch(m_status[listIndex]){
      case 1:
      case 2:
        return m_currentDT.secsTo(earthDTScheduleDeparture[listIndex]);
        break;
      case 3:
        return m_currentDT.secsTo(earthDTScheduleArrivedist[listIndex]);
        break;
    }
    return 0;
}

QString QVSShipTimeCalc::getSchedule(int listIndex)
{
    return m_strSchedule[listIndex];
}

QVSShipTimeTable::QVSShipTimeTable(QWidget* parent):QWidget(parent)
{
/*
    // ιԤ
    // ӥʡݥޥ
    m_calcShipSM = new QVSShipTimeCalc(3, m_strArrivalSM, m_strDepartureSM, m_strArrivDestSM, 4);
*/


}

QVSShipTimeTableFromJ::QVSShipTimeTableFromJ(QWidget* parent):QVSShipTimeTable(parent)
{
    this->init();
    this->initbase();
}
QVSShipTimeTableToJ::QVSShipTimeTableToJ(QWidget* parent):QVSShipTimeTable(parent)
{
    this->init();
    this->initbase();
}


void QVSShipTimeTableFromJ::init()
{
    // ȯ
    m_calcShipSchedule[0] = new QVSShipTimeCalc(4, QVSShipTimeData::ArrivalJ2S, QVSShipTimeData::DepartureJ2S, QVSShipTimeData::ArrivDestJ2S, QVSShipTimeData::DepartureDispJ2S, 2);
    m_calcShipSchedule[1] = new QVSShipTimeCalc(4, QVSShipTimeData::ArrivalJ2B, QVSShipTimeData::DepartureJ2B, QVSShipTimeData::ArrivDestJ2B, QVSShipTimeData::DepartureDispJ2B, 2);
    m_calcShipSchedule[2] = new QVSShipTimeCalc(4, QVSShipTimeData::ArrivalJ2W, QVSShipTimeData::DepartureJ2W, QVSShipTimeData::ArrivDestJ2W, QVSShipTimeData::DepartureDispJ2W, 2);
    m_calcShipSchedule[3] = new QVSShipTimeCalc(4, QVSShipTimeData::ArrivalJ2K, QVSShipTimeData::DepartureJ2K, QVSShipTimeData::ArrivDestJ2K, QVSShipTimeData::DepartureDispJ2K, 2);

    m_sTitle = "΢ͳƹ";
    m_sCityNameL[0] = "ɥꥢ";
    m_sCityNameL[1] = "Хȥ";
    m_sCityNameL[2] = "";
    m_sCityNameL[3] = "";
    m_sCityNameS[0] = "ɹ";
    m_sCityNameS[1] = "Х";
    m_sCityNameS[2] = "";
    m_sCityNameS[3] = "";
}

void QVSShipTimeTableToJ::init()
{
    // ι
    m_calcShipSchedule[0] = new QVSShipTimeCalc(4, QVSShipTimeData::ArrivalS2J, QVSShipTimeData::DepartureS2J, QVSShipTimeData::ArrivDestS2J, QVSShipTimeData::DepartureDispS2J, 2);
    m_calcShipSchedule[1] = new QVSShipTimeCalc(4, QVSShipTimeData::ArrivalB2J, QVSShipTimeData::DepartureB2J, QVSShipTimeData::ArrivDestB2J, QVSShipTimeData::DepartureDispB2J, 2);
    m_calcShipSchedule[2] = new QVSShipTimeCalc(4, QVSShipTimeData::ArrivalW2J, QVSShipTimeData::DepartureW2J, QVSShipTimeData::ArrivDestW2J, QVSShipTimeData::DepartureDispW2J, 2);
    m_calcShipSchedule[3] = new QVSShipTimeCalc(4, QVSShipTimeData::ArrivalK2J, QVSShipTimeData::DepartureK2J, QVSShipTimeData::ArrivDestK2J, QVSShipTimeData::DepartureDispK2J, 2);

    m_sTitle = "ƹͥ";
    m_sCityNameL[0] = "ɥꥢȯ";
    m_sCityNameL[1] = "Хȥȯ";
    m_sCityNameL[2] = "ȯ";
    m_sCityNameL[3] = "ȯ";
    m_sCityNameS[0] = "ȯ";
    m_sCityNameS[1] = "Хȯ";
    m_sCityNameS[2] = "ȯ";
    m_sCityNameS[3] = "ȯ";
}

void QVSShipTimeTable::initbase()
{
    QFont font;
    font.setPointSize(20);

    m_pMainBox = new QGroupBox(this);
    m_pMainBox->setTitle(tr(m_sTitle));

    m_pHeader[0] = new QLabel(tr(""),m_pMainBox);
    m_pHeader[1] = new QLabel(tr("ȯ"),m_pMainBox);
    m_pHeader[2] = new QLabel(tr("Ļ(ET)"),m_pMainBox);
    m_pHeader[3] = new QLabel(tr(""),m_pMainBox);

    for(int i = 0; i <=3; i++){
      m_pHeader[i]->setFont(font);
    }

    QPalette col[4] = {QPalette(QColor(255, 128, 128)),
                       QPalette(QColor(128, 128, 255)),
                       QPalette(QColor(255, 255, 128)),
                       QPalette(QColor(128, 255, 128))};
    for(int i = 0; i <=3; i++){
      m_pShipItemDest[i] = new QLabel(m_pMainBox);
      m_pShipItemDest[i]->setPalette(col[i]);
      m_pShipItemDest[i]->setFrameStyle(QFrame::Panel | QFrame::Sunken);
      m_pShipItemDest[i]->setLineWidth(2);
      m_pShipItemDest[i]->setFont(font);
    }
    for(int i = 0; i < 8; i++){
      m_pShipItemBox[i] = new QHBox(m_pMainBox);
      m_pShipItemBox[i]->setFrameStyle(QFrame::Panel | QFrame::Sunken);
      m_pShipItemBox[i]->setLineWidth(2);
      m_pShipItemBox[i]->setPalette(QPalette(QColor(255, 255, 255)));
      for(int j = 0; j < 4; j++){
        m_pShipItem[i][j] = new QLabel(m_pShipItemBox[i]);
        m_pShipItem[i][j]->setPalette(QPalette(QColor(255, 255, 255)));
        m_pShipItem[i][j]->setFont(font);
        m_pShipItem[i][j]->setAlignment(AlignLeft | AlignTop);
      }
    }
}

void QVSShipTimeTable::resizeLayout(int mode)
{
    if(mode == 0){
      m_pMainBox->setGeometry(5,2,627,260);
      m_pHeader[0]->setGeometry(190,13,100,20);
      m_pHeader[1]->setGeometry(280,13,100,20);
      m_pHeader[2]->setGeometry(370,13,100,20);
      m_pHeader[3]->setGeometry(543,13, 60,20);

      for(int i = 0; i <=3; i++){
        m_pShipItemDest[i]->setText(tr(m_sCityNameL[i]));
      }
      m_pShipItemDest[0]->setGeometry(10, 36,160,51);
      m_pShipItemDest[1]->setGeometry(10, 90,160,51);
      m_pShipItemDest[2]->setGeometry(10,144,160,51);
      m_pShipItemDest[3]->setGeometry(10,198,160,51);

      for(int i = 0; i < 8; i++){
        m_pShipItemBox[i]->setGeometry(170,36+25*i+i/2*4,445,25);
        m_pShipItem[i][0]->setFixedSize(80,20);
        m_pShipItem[i][1]->setFixedSize(70,20);
        m_pShipItem[i][2]->setFixedSize(160,20);
        m_pShipItem[i][3]->setFixedSize(60,20);
      }

    }else{
      m_pMainBox->setGeometry(5,2,467,270);
      m_pHeader[0]->setGeometry(120,23,80,20);
      m_pHeader[1]->setGeometry(184,23,80,20);
      m_pHeader[2]->setGeometry(250,23,100,20);
      m_pHeader[3]->setGeometry(392,23,60,20);

      for(int i = 0; i <=3; i++){
        m_pShipItemDest[i]->setText(tr(m_sCityNameS[i]));
      }
      m_pShipItemDest[0]->setGeometry(10, 46,95,51);
      m_pShipItemDest[1]->setGeometry(10,100,95,51);
      m_pShipItemDest[2]->setGeometry(10,154,95,51);
      m_pShipItemDest[3]->setGeometry(10,208,95,51);

      for(int i = 0; i < 8; i++){
        m_pShipItemBox[i]->setGeometry(105,46+25*i+i/2*4,350,25);
        m_pShipItem[i][0]->setFixedSize(63,20);
        m_pShipItem[i][1]->setFixedSize(58,20);
        m_pShipItem[i][2]->setFixedSize(138,20);
        m_pShipItem[i][3]->setFixedSize(60,20);
      }

    }

}

void QVSShipTimeTable::refresh()
{
    // ߻
    QDateTime curDT = QDateTime::currentDateTime();
    // ȯ
    for(int i = 0; i < 4; i++){
      int update = m_calcShipSchedule[i]->setCurrentDateTime(curDT);
      if(update == 0){
        continue;
      }
      long remainSec;
      QString strRemain;
      long strOrderPos = 0;
      for(int j = 0; j < 2; j++){
        remainSec = m_calcShipSchedule[i]->getRemainSec(j);
        switch(m_calcShipSchedule[i]->getStatus(j)){
          case 1:
            strRemain.sprintf("ȯޤ%02ld:%02ld", remainSec/60, remainSec%60);
            break;
          case 2:
            strRemain.sprintf("ȯޤ%02ld:%02ld", remainSec/60, remainSec%60);
            break;
          case 3:
            strRemain.sprintf("ޤ%02ld:%02ld", remainSec/60, remainSec%60);
            break;
        }
        m_pShipItem[i*2+j][2]->setText(tr(strRemain));
        
      }
      if(update == 1){
        continue;
      }
      for(int j = 0; j < 2; j++){
        switch(m_calcShipSchedule[i]->getStatus(j)){
          case 1:
            m_pShipItem[i*2+j][3]->setText(tr(""));
            for(int k = 0; k <= 2; k++){
              m_pShipItemBox[i*2+j]->setPalette(QPalette(QColor(255, 255, 255)));
              m_pShipItem[i*2+j][k]->setPalette(QPalette(QColor(255, 255, 255)));
            }
            m_pShipItem[i*2+j][3]->setPalette(QPalette(QColor(128, 255, 128)));
            break;
          case 2:
            m_pShipItem[i*2+j][3]->setText(tr(""));
            for(int k = 0; k <= 2; k++){
              m_pShipItemBox[i*2+j]->setPalette(QPalette(QColor(255, 255, 255)));
              m_pShipItem[i*2+j][k]->setPalette(QPalette(QColor(255, 255, 255)));
            }
            m_pShipItem[i*2+j][3]->setPalette(QPalette(QColor(255, 128, 128)));
            break;
          case 3:
            m_pShipItem[i*2+j][3]->setText(tr("ҹ"));
            for(int k = 0; k <= 3; k++){
              m_pShipItemBox[i*2+j]->setPalette(QPalette(QColor(150, 150, 150)));
              m_pShipItem[i*2+j][k]->setPalette(QPalette(QColor(150, 150, 150)));
            }
            break;
        }
        m_pShipItem[i*2+j][1]->setText(m_calcShipSchedule[i]->getSchedule(j));
      }

      switch(m_calcShipSchedule[i]->getStatus(0)){
        case 1:
        case 2:
          strOrderPos = 1;
          break;
        case 3:
          strOrderPos = 0;
          break;
      }
      for(int j = 0; j < 2; j++){
        m_pShipItem[i*2+j][0]->setText(tr(m_strOrder[strOrderPos+j]));
      }

    }

}

