/*
QVanaClock -- Vana'diel Clock for Zaurus SL-C Series.
Copyright (C) 2004 Gussan(http://sourceforge.jp/users/gsn/)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include "qvstimer.h"

QVSStartButton::QVSStartButton(QWidget* parent, QString hotkey) : QPushButton(parent, 0)
{
    QString strBtn(tr("¬"));
    m_strHotkey = "";

    if(!(hotkey.isNull())){
      m_strHotkey = "(&";
      m_strHotkey += hotkey;
      m_strHotkey += ")";
    }

    strBtn += m_strHotkey;
    setText(strBtn);

}

void QVSStartButton::buttonNameChange(int fStatus)
{
    QString strBtn;

    switch(fStatus){
    case 0:    // initial/reset
      strBtn = tr("¬");
      break;
    case 1:    // stopped
      strBtn = tr("Ƴ");
      break;
    case 2:    // running
      strBtn = tr("Ʒ¬");
      break;
    }
    strBtn += m_strHotkey;
    setText(strBtn);
}

QVSResetButton::QVSResetButton(QWidget* parent) : QPushButton(parent, 0)
{
    setText(QString("Reset"));
    setMinimumWidth(65);
}

void QVSResetButton::buttonNameChange(int fStatus)
{
    QString strBtn;

    switch(fStatus){
    case 0:    // initial/reset
    case 1:    // stopped
      strBtn = "Reset";
      break;
    case 2:    // running
      strBtn = "Stop";
      break;
    }
    setText(strBtn);
}



QVSForRewButton::QVSForRewButton(QWidget* parent, QString caption) : QPushButton(parent, 0)
{
    setText(caption);
    setFixedWidth(28);
    setMinimumWidth(16);
}

QVSTimeDisp::QVSTimeDisp(QWidget* parent) : QLabel(parent, 0)
{
    setAlignment(Qt::AlignRight);

    QFont newFont;
    newFont.setPointSize(42);
    setFont(newFont);

    setFixedHeight(36);
    //setFrameStyle( QFrame::Panel | QFrame::Raised );
    display_initial();
}

void QVSTimeDisp::display(long iTime)
{

    long time;
    char sign;
    if(iTime >= 0){
      time = iTime;
      sign = ' ';
    }else{
      time = -iTime;
      sign = '-';
    }
    QString str;
    str.sprintf("%c%02ld:%02ld", sign, (time/60), (time%60));

    setText(str);

    if(iTime <= 0){
      setPalette(QPalette(QColor(255,0,0)));
    } else if(1 <= iTime && iTime <= 15){
      setPalette(QPalette(QColor(255,255,0)));
    }else{
      unsetPalette();
    }


}

void QVSTimeDisp::display_initial()
{
    unsetPalette();
    setText(QString(" --:--"));
}


QVSTimeSelect::QVSTimeSelect(QWidget* parent) : QComboBox(true, parent)
{
  QString timelist[15] = {"10","16","1","2","3","4","5","6","7","8","9","30","120","0","999"};
  for(int i = 0; i < 15; i++){
    insertItem(timelist[i]);
  }
  setMinimumWidth(22);
  setInsertionPolicy(NoInsertion);

  // 0-999ޤOK
  //   ȤäɡϤIntermediateȤƼդ㤦ѻϤϤɡ
  //   礦ʤΤǡȻȽ
  m_pIntValid = new QIntValidator(this);
  m_pIntValid->setRange(0,999);
  setValidator(m_pIntValid);

}

long QVSTimeSelect::getTime()
{
  int iSelect = atoi(currentText());
  if(iSelect < 0){
    setCurrentItem(count()-2);
    iSelect = 0;
  }else if(iSelect > 999){
    setCurrentItem(count()-1);
    iSelect = 999;
  }
  iSelect = iSelect * 60;  //ä֤
  return iSelect;
}

// ܥܥå˿Ϥξ롣Ȥignore(ƥåȤꤲ)
void QVSTimeSelect::keyReleaseEvent ( QKeyEvent * e )
{
    QString key;
    key = e->text();
    bool ok;
    key.toInt( &ok, 10 );  // 10ѴƤߤ

    if(ok){
      e->accept();
    }else{
      e->ignore();
    }

};

QVSTimerItem::QVSTimerItem(QWidget* parent, QString akey):QVBox(parent)
{
    this->setMargin(2);
    //this->setFrameStyle( QFrame::Panel | QFrame::Plain );

    m_pHbox1 = new QHBox(this);
    m_pTimedisp = new QVSTimeDisp(m_pHbox1);
    m_pRewbutton = new QVSForRewButton(m_pHbox1,"<");
    m_pForbutton = new QVSForRewButton(m_pHbox1,">");

    m_strAcclKey = akey;
    m_pSbutton = new QVSStartButton(this, QString(akey.at(0)));

    m_pHbox2 = new QHBox(this);
    m_pTcombo = new QVSTimeSelect(m_pHbox2);
    m_pRbutton = new QVSResetButton(m_pHbox2);

    connect(m_pSbutton, SIGNAL(clicked()), this, SLOT(handleStart()));
    connect(m_pRbutton, SIGNAL(clicked()), this, SLOT(handleReset()));
    connect(m_pRewbutton, SIGNAL(clicked()), this, SLOT(handleRewind()));
    connect(m_pForbutton, SIGNAL(clicked()), this, SLOT(handleForward()));

    m_status = 0;         // 0:initial/reset, 1:stopped, 2:running
    //m_StartTime = QDateTime();  // ¬ϻ(runningˤʤä)λ(QDateTime֥)
    m_setTime = 0;        // /ƥȤݤΥޡå()
    m_userSetTime = 0;    // 桼åȤޡå()
}

QVSTimerItem::~QVSTimerItem()
{
    delete m_pRbutton;    m_pRbutton   = NULL;
    delete m_pTcombo;     m_pTcombo    = NULL;
    delete m_pHbox2;      m_pHbox2     = NULL;
    delete m_pSbutton;    m_pSbutton   = NULL;
    delete m_pForbutton;  m_pForbutton = NULL;
    delete m_pRewbutton;  m_pRewbutton = NULL;
    delete m_pTimedisp;   m_pTimedisp  = NULL;
    delete m_pHbox1;      m_pHbox1     = NULL;
}

void QVSTimerItem::handleStart()
{
    switch(m_status){
    case 0:
      m_userSetTime = m_pTcombo->getTime();
      m_setTime = m_userSetTime;
      m_status = 2;
      break;
    case 1:      // Stopm_remainTimem_setTime˥ԤäƤΤǡƳξm_setTimeΥåȤ
      m_status = 2;
      break;
    case 2:
      m_userSetTime = m_pTcombo->getTime();
      m_setTime = m_userSetTime;
      m_status = 2;
      break;
    }

    m_StartTime = QDateTime::currentDateTime();
    m_remainTime = m_setTime * 60;  // ߤɽ

    m_pSbutton->buttonNameChange(m_status);
    m_pRbutton->buttonNameChange(m_status);
    m_pSbutton->setFocus();

    refresh();

    // ơѲʥȯ
    emit statusChanged();
}

void QVSTimerItem::handleReset()
{
    switch(m_status){
    case 0:      // ѲʤΤǡʤˤ⤷ʤ
      break;
    case 1:      // ξϥꥻå
      Reset();
      break;
    case 2:      // runningξϰ
      m_setTime = m_remainTime;
      m_status = 1;
      break;
    }

    m_pSbutton->buttonNameChange(m_status);
    m_pRbutton->buttonNameChange(m_status);
    m_pSbutton->setFocus();

    // ơѲʥȯ
    emit statusChanged();
}



void QVSTimerItem::handleRewind()
{
    if(m_status == 2){
      long rtime = m_setTime - m_StartTime.secsTo(QDateTime::currentDateTime());
      if(rtime > 999*60){
        return;
      }
      m_StartTime = m_StartTime.addSecs(10);
    }
}

void QVSTimerItem::handleForward()
{
    if(m_status == 2){
      long rtime = m_setTime - m_StartTime.secsTo(QDateTime::currentDateTime());
      if(rtime < -99*60){
        return;
      }
      m_StartTime = m_StartTime.addSecs(-10);
    }
}
void QVSTimerItem::refresh()
{
    if(m_status == 2){
      long rtime = 0;
      rtime = m_setTime - m_StartTime.secsTo(QDateTime::currentDateTime());
      if(m_remainTime != rtime){  // в֤ñ̤ѤäƤʤäʤ
        m_remainTime = rtime;
        m_pTimedisp->display(m_remainTime);
        return;
      }
      // -99ʬۤꥻåȤ롣
      if(m_remainTime < -99*60){
        Reset();
        m_pSbutton->buttonNameChange(m_status);
        m_pRbutton->buttonNameChange(m_status);
      }
    }
}
void QVSTimerItem::Reset()
{
    m_StartTime = QDateTime();
    m_setTime = 0;
    m_userSetTime = 0;
    m_pTimedisp->display_initial();
    m_status = 0;

    // ơѲʥȯ
    emit statusChanged();
}

int QVSTimerItem::isRunning()
{
    switch(m_status){
    case 0:      // ꥻåȾ
    case 1:      // 
      return 0;
      break;
    case 2:      // running
      return 1;
      break;
    }
}

void QVSTimerItem::setItemFocus()
{
    m_pSbutton->setFocus();
}

QVSTimerWindow::QVSTimerWindow(QWidget* parent) : QGrid(3, parent)
{

    QString accelKeyList[9] = {"1qa","2ws","3ed","4rf","5tg","6yh","7uj","8ik","9ol"};

    for(int i = 0; i <=1; i++){
      for(int j = 0; j <= 2; j++){
        m_pTimerItem[i*3+j] = new QVSTimerItem(this, accelKeyList[i*3+j]);
        connect(m_pTimerItem[i*3+j], SIGNAL(statusChanged()), this, SLOT(handleStatusChanged()));
      }
    }
    m_pTimerItem[0]->setItemFocus();
}

void QVSTimerWindow::keyReleaseEvent ( QKeyEvent * e )
{
    QString key;
    key = e->text();

    //printf("%s\n",key.latin1());
    for(int i = 0; i<= 5; i++){
      if(!key.isEmpty() && m_pTimerItem[i]->getAcclKey().find(key,0,FALSE) >= 0){ // ʸʸ̤ʤǸ
        m_pTimerItem[i]->handleStart();
        break;
      }
    }

}

void QVSTimerWindow::refresh()
{
    for(int i = 0; i < 6; i++){
      m_pTimerItem[i]->refresh();
    }

}

int QVSTimerWindow::isRunning()
{
    for(int i = 0; i < 6; i++){
      if(m_pTimerItem[i]->isRunning()){
        return 1; //ҤȤĤǤRunningʤTRUE
      }
    }
    return 0;
}

void QVSTimerWindow::handleStatusChanged()
{
    emit statusChanged();
}
