// Index.h
// 2008/12/03

#pragma once

namespace QAX {

// IndexEntry
struct IndexEntry {

	UINT64 Sample;
	UINT64 Position;
	UINT32 Offset;

}; // IndexEntry

// IndexArray
class IndexArray {

	std::vector<IndexEntry> m_Index;

	UINT64 m_Samples;

public:

	IndexArray() : m_Samples(0)
	{
	}

	~IndexArray()
	{
	}

	bool IsEmpty()
	{
		return m_Index.empty();
	}

	void ParseIndex(
		const VOID* pos,
		SIZE_T      size,
		UINT64      last_sample)
	{
		const BYTE* p = static_cast<const BYTE*>(pos);
		const BYTE* end = p + size;

		UINT32 count;
		p += DecodeVNumber(p, end, &count);

		UINT64 sample   = 0;
		UINT64 position = 0;

		m_Index.resize(count + 1);

		IndexEntry* e = &(m_Index[0]);

		for (UINT32 i = 0; i < count; i++, e++) {
			UINT32 size;
			p += DecodeVNumber(p, end, &size);

			UINT32 duration;
			p += DecodeVNumber(p, end, &duration);

			UINT32 offset;
			p += DecodeVNumber(p, end, &offset);

			e->Sample   = sample;
			e->Position = position;
			e->Offset   = offset;

			sample   += duration;
			position += size;
		}

		e->Sample   = sample;
		e->Position = position;
		e->Offset   = UINT32(-1);

		m_Samples = last_sample;
	}

	const IndexEntry& SeekIndex(
		UINT64 pos)
	{
		if (pos >= m_Samples) {
			FormatError::Throw("SeekIndex.OutOfRange");
		}

		const IndexEntry* s = &(m_Index[0]);
		const IndexEntry* e = s + m_Index.size() - 1;

		while (s < e) {
			const IndexEntry* p = s + (e - s) / 2;

			if (pos >= p[0].Sample && pos < p[1].Sample) {
				if (pos < p->Sample + p->Offset) {
					p -= 1;
				}

				return *p;

			} else if (pos < p->Sample) {
				e = p;

			} else {
				s = p + 1;
			}
		}

		FormatError::Throw("SeekIndex.Invalid");
	}

}; // IndexArray

} // namespace QAX

