// QAXDecoder.cpp
// 2008/11/27

#include "StdAfx.h"

#include "QAXDecoder.h"

#include "QAXFileSpec.h"

#include "Utils.h"

#include "FileMapping.h"

#include "DecoderFactory.h"

#include "Index.h"

#include "Output.h"

#include "Decoder.h"

#include "QASOutput.h"

#include "WaveWriter.h"

namespace QAX {

/* */

CriticalSection g_cs_codec;

/* */

const BYTE VN_SIZE[0x100] = {
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 7, 8, 9, 0
};

/* */

UINT32 CRC32::CRC_TABLE[0x100];

/* */


UINT32 g_OFFSET_ALIGN;
UINT32 g_PAGE_SIZE;

/* */

API_EXTERN bool STDCALL Initialize()
{
	if (!QV_Initialize()) {
		return false;
	}

	SYSTEM_INFO si = { 0 };
	GetSystemInfo(&si);

	g_OFFSET_ALIGN = si.dwAllocationGranularity;
	g_PAGE_SIZE    = si.dwPageSize;

	CRC32::MakeTable();

	return true;
}

API_EXTERN QFileMapping* STDCALL QFileMappingCreate(
	LPCWSTR path)
{
	QFileMapping* p = FileMappingImpl::Create(path);
	return p;
}

API_EXTERN QDecoderFactory* STDCALL QDecoderFactoryCreate()
{
	QDecoderFactory* p = DecoderFactoryImpl::Create();
	return p;
}

API_EXTERN QDecoder* STDCALL QDecoderCreate(
	QDecoderFactory* pFactory,
	QFileMapping*    pFileMapping)
{
	QDecoder* p = DecoderImpl::Create(pFactory, pFileMapping);
	return p;
}

/* */

API_EXTERN IStream* STDCALL StreamReaderCreate(
	LPCWSTR path)
{
	IStream* p = 0;
	HRESULT hRslt = SHCreateStreamOnFileW(
		path,
		STGM_READ | STGM_SHARE_DENY_WRITE,
		&p);
	if (FAILED(hRslt)) {
		COMError::Throw("SHCreateStreamOnFileW", hRslt);
	}

	return p;
}

API_EXTERN QDecoderOutput* STDCALL QASDecoderOutputCreate(
	QDecoderFactory* pFactory,
	IStream*         pStream)
{
	QDecoderOutput* p = QASVorbisOutputImpl::Create(pFactory, pStream);
	return p;
}

/* */

} // namespace QAX

