/* BitDecoder.h */
/* 2008/11/05   */

#pragma once

/* BitDecoder */
struct BitDecoder {

	UINT64 Cache;
	INT32  Count;

	const BYTE* p;
	const BYTE* end;

}; /* BitDecoder */

typedef struct BitDecoder BitDecoder_t;

void BitDecoder_Init(
	BitDecoder_t* t,
	const VOID*   p,
	SIZE_T        length);

UINT32 BitDecoder_GetBits(
	BitDecoder_t* t,
	INT           bits);

UINT32 BitDecoder_PeekBits(
	BitDecoder_t* t,
	INT           bits);

void BitDecoder_SkipBits(
	BitDecoder_t* t,
	INT           bits);

