/* MemoryPool.c */
/* 2008/11/05   */

#include "StdAfx.h"

#include "MemoryPool.h"

struct MemoryBlock;

typedef struct MemoryBlock MemoryBlock_t;

struct MemoryBlock {

	MemoryBlock_t* Next;

	SIZE_T Size;

	UINT32 Padding[2];

};

/* */

void MemoryPool_Init(
	MemoryPool_t* t)
{
	t->Block     = NULL;
	t->TotalSize = 0;

	t->Backyard        = NULL;
	t->BackyardSize    = 0;
	t->MaxBackyardSize = 0;
}

void MemoryPool_Release(
	MemoryPool_t* t)
{
	MemoryBlock_t* p = (MemoryBlock_t*)(t->Block);
	while (p != NULL) {
		MemoryBlock_t* n = p->Next;
		_aligned_free(p);
		p = n;
	}

	t->Block     = NULL;
	t->TotalSize = 0;
}

VOID* MemoryPool_Allocate(
	MemoryPool_t* t,
	SIZE_T        cb)
{
	MemoryBlock_t* b = (MemoryBlock_t*)_aligned_malloc(
		sizeof(MemoryBlock_t) + cb,
		0x10);
	if (b == NULL) {
		return NULL;
	}

	b->Next = t->Block;
	b->Size = cb;

	t->Block      = b;
	t->TotalSize += cb;

	return b + 1;
}

/* */

VOID* MemoryPool_EnterBackyard(
	MemoryPool_t* t)
{
	return t->Backyard;
}

void MemoryPool_LeaveBackyard(
	MemoryPool_t* t,
	VOID*         ctx)
{
	MemoryBlock_t* p = (MemoryBlock_t*)(t->Backyard);
	while (p != ctx) {
		MemoryBlock_t* n = p->Next;

		t->BackyardSize -= p->Size;

		_aligned_free(p);
		p = n;
	}

	t->Backyard = ctx;
}

VOID* MemoryPool_AllocateBackyard(
	MemoryPool_t* t,
	SIZE_T        cb)
{
	MemoryBlock_t* b = (MemoryBlock_t*)_aligned_malloc(
		sizeof(MemoryBlock_t) + cb,
		0x10);
	if (b == NULL) {
		return NULL;
	}

	b->Next = t->Backyard;
	b->Size = cb;

	t->Backyard      = b;
	t->BackyardSize += cb;

	if (t->MaxBackyardSize < t->BackyardSize) {
		t->MaxBackyardSize = t->BackyardSize;
	}

	return b + 1;
}

/* */

