/* TransformIMDCT.h */
/* 2008/11/10       */

#pragma once

#include "MemoryPool.h"

/* */

void TransformIMDCT_Init(MemoryPool_t* pool);
void TransformIMDCT_Uninit(void);

/* */

void FFT8_SSE2(
	INT32        n,
	const FLOAT* Ar,
	const FLOAT* Ai,
	FLOAT*       Zr,
	FLOAT*       Zi);

/* */

struct FFT {

	FLOAT* C[8];
	FLOAT* S[8];
	INT16* I[8];

}; /* FFT */

typedef struct FFT FFT_t;

struct FFT_N {

	INT32 n;
	INT32 start;

	const FFT_t* t;

	FLOAT* xr;
	FLOAT* xi;

}; /* FFT_N */

typedef struct FFT_N FFT_N_t;

/* */

void FFT_N_SSE2(
	FFT_N_t*     t,
	const FLOAT* ar,
	const FLOAT* ai,
	FLOAT*       zr,
	FLOAT*       zi);

/* */

struct IMDCT {

	FLOAT* C[8];
	FLOAT* S[8];

}; /* IMDCT */

typedef struct IMDCT IMDCT_t;

struct IMDCT_N {

	INT32 n;
	INT32 index;

	const IMDCT_t* t;

	FFT_N_t* fft;

	FLOAT* xr;
	FLOAT* xi;

	FLOAT* y;

}; /* IMDCT_N */

typedef struct IMDCT_N IMDCT_N_t;

/* */

void IMDCT_N_Execute_SSE2(
	IMDCT_N_t*   t,
	const FLOAT* x,
	FLOAT*       z);

/* */

