// Item.cs
// 2008/11/19

using System;
using System.IO;
using System.Collections.Generic;

namespace QAX {

// ItemProperty
public struct ItemProperty {

	public Int32 Type;
	public Int32 Value;

} // ItemProperty

// ItemEntry
public struct ItemEntry {

	public String Key;

	public Int32 Type;
	public Int32 Name;
	public Int32 Setup;
	public Int32 Index;

	public UInt64 Position;
	public UInt64 Size;

	public UInt64 Samples;

	public ItemProperty[] Props;

} // ItemEntry

// ItemPool
public class ItemPool {

	private List<ItemEntry> _list;

	public ItemPool()
	{
		_list = new List<ItemEntry>();
	}

	public void Add(ItemEntry e)
	{
		_list.Add(e);
	}

	private static Byte[] ToArray(ItemEntry item)
	{
		var ms = new MemoryStream();

		Int32 len;
		Byte[] buffer = new Byte[32];

		using (var w = new BinaryWriter(ms)) {
			len  = Utils.ToBinary((UInt64)item.Type,  buffer, 0,   buffer.Length      );
			len += Utils.ToBinary((UInt64)item.Name,  buffer, len, buffer.Length - len);
			len += Utils.ToBinary((UInt64)item.Setup, buffer, len, buffer.Length - len);
			len += Utils.ToBinary((UInt64)item.Index, buffer, len, buffer.Length - len);

			w.Write(buffer, 0, len);

			len  = Utils.ToBinary(item.Position, buffer, 0,   buffer.Length      );
			len += Utils.ToBinary(item.Size,     buffer, len, buffer.Length - len);
			len += Utils.ToBinary(item.Samples,  buffer, len, buffer.Length - len);

			w.Write(buffer, 0, len);

			if (item.Props == null) {
				len = Utils.ToBinary(0, buffer, 0, buffer.Length);
				w.Write(buffer, 0, len);

			} else {
				len = Utils.ToBinary((UInt64)item.Props.Length, buffer, 0, buffer.Length);
				w.Write(buffer, 0, len);

				for (Int32 i = 0; i < item.Props.Length; i++) {
					len  = Utils.ToBinary((UInt64)item.Props[i].Type,  buffer, 0,   buffer.Length      );
					len += Utils.ToBinary((UInt64)item.Props[i].Value, buffer, len, buffer.Length - len);

					w.Write(buffer, 0, len);
				}
			}
		}

		return ms.ToArray();
	}

	public Chunk ToChunk()
	{
		var chunk = new Chunk();

		var ms = new MemoryStream();

		Int32 index = 0;

		using (var w = new BinaryWriter(ms)) {
			ItemEntry[] items = _list.ToArray();
			Int32[]     lens  = new Int32[items.Length];

			/* Sort */

			for (Int32 i = 0; i < items.Length; i++) {
				Byte[] data = ToArray(items[i]);

				w.Write(data);

				lens[i] = data.Length;

				index += data.Length;
			}

			Utils.WriteLengths(w, lens);
		}

		chunk.Payload = ms.ToArray();
		chunk.Index   = index;

		return chunk;
	}

} // ItemPool

} // namespace QAX

