// Setup.h
// 2008/11/18

#pragma once

using namespace System;

namespace QVorbis {

// Setup
public ref class Setup : public IDisposable {

	QVorbisDecoderSetup_t* m_setup;

public:

	Setup() : m_setup(0)
	{
		m_setup = QV_CreateDecoderSetup();
		if (m_setup == 0) {
			throw gcnew OutOfMemoryException();
		}
	}

	~Setup()
	{
		if (m_setup != 0) {
			QV_ReleaseDecoderSetup(m_setup);
			m_setup = 0;
		}
	}

	property QVorbisDecoderSetup_t* DecoderSetup {
		QVorbisDecoderSetup_t* get()
		{
			return m_setup;
		}
	}

	void Create(
		array<Byte>^ id,
		array<Byte>^ setup)
	{
		pin_ptr<Byte> p0 = &(id[0]);
		pin_ptr<Byte> p1 = &(setup[0]);

		if (!QV_SetupDecoderSetup(
			m_setup,
			p0,
			id->Length,
			p1,
			setup->Length)) {
			throw gcnew Error("QV_SetupDecoderSetup");
		}
	}

	Int32 GetChannels()
	{
		return QV_GetDecoderSetupChannels(m_setup);
	}

	Int32 GetSamplingRate()
	{
		return QV_GetDecoderSetupSamplingRate(m_setup);
	}

}; // Setup

} // namespace QVorbis

