/**
 * Copyright (C) 2009 root42 Inc. All rights reserved.
 */
package jp.root42.r42fw.export.web.ui.components;

import java.io.Writer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.opensymphony.xwork2.util.ValueStack;

import org.apache.struts2.components.Include;

import jp.root42.r42fw.export.web.ui.components.scope.LocalVariableScope;
import jp.root42.r42fw.export.web.ui.components.scope.LocalVariableScopeAware;
import jp.root42.r42fw.export.web.ui.components.scope.LocalVariableScopeFactory;


/**
 * @since 1.0
 * @author root42 Inc.
 * @version $Id: MergeComponent.java 1 2009-07-01 06:44:12Z takahashikzn $
 */
public class MergeComponent
    extends Include
    implements LocalVariableScopeAware {

    /** {@link #localVariableScope} */
    private final LocalVariableScope localVariableScope;

    /**
     * @param stack
     * stack
     * @param request
     * request
     * @param response
     * response
     */
    public MergeComponent(
        final ValueStack stack, final HttpServletRequest request,
        final HttpServletResponse response) {
        super(stack, request, response);

        this.localVariableScope =
            LocalVariableScopeFactory.getInstance().create(stack, request,
                response);
    }

    /** {@inheritDoc} */
    @Override
    public boolean start(final Writer writer) {
        this.localVariableScope.openScope();

        return super.start(writer);
    }

    /** {@inheritDoc} */
    @Override
    public boolean end(final Writer writer, final String body) {
        final boolean result = super.end(writer, body);

        this.localVariableScope.closeScope();

        return result;
    }

    /** {@inheritDoc} */
    @Override
    public LocalVariableScope getLocalVariableScope() {
        return this.localVariableScope;
    }
}
