/**
 * Copyright (C) 2009 root42 Inc. All rights reserved.
 */
package jp.root42.r42fw.export.web.ui.components.scope;

/**
 * ローカル変数のスコープを定義します。
 * 
 * @since 1.0
 * @author root42 Inc.
 * @version $Id: LocalVariableScope.java 1 2009-07-01 06:44:12Z takahashikzn $
 */
public interface LocalVariableScope {
    /**
     * スコープをオープンします。
     */
    void openScope();

    /**
     * スコープをクローズします。
     */
    void closeScope();

    /**
     * ローカル変数を定義します。
     * 
     * @param key
     * key
     * @param value
     * value
     */
    void setVar(String key, Object value);
}
