/**
 * Copyright (C) 2009 root42 Inc. All rights reserved.
 */
package jp.root42.r42fw.export.web.ui.jsptags;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.opensymphony.xwork2.util.ValueStack;

import org.apache.struts2.views.jsp.ComponentTagSupport;

import jp.root42.r42fw.export.web.ui.components.MergeComponent;


/**
 * @since 1.0
 * @author root42 Inc.
 * @version $Id: MergeComponentTag.java 1 2009-07-01 06:44:12Z takahashikzn $
 */
public class MergeComponentTag
    extends ComponentTagSupport {

    /** {@link #serialVersionUID} */
    private static final long serialVersionUID = -3351174801511819515L;

    /***/
    private String src;

    /** {@inheritDoc} */
    @Override
    public MergeComponent getBean(final ValueStack stack,
        final HttpServletRequest req, final HttpServletResponse res) {
        return new MergeComponent(stack, req, res);
    }

    /** {@inheritDoc} */
    @Override
    protected void populateParams() {
        super.populateParams();

        ((MergeComponent) this.component).setValue(this.src);
    }

    /**
     * @param src
     * src
     */
    public void setSrc(final String src) {
        this.src = src;
    }
}
