/**
 * Copyright (C) 2009 root42 Inc. All rights reserved.
 */
package jp.root42.r42fw.export.web.ui.components;

import java.io.Writer;

import com.opensymphony.xwork2.util.ValueStack;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.components.ContextBean;

import jp.root42.r42fw.export.web.ui.components.scope.LocalVariableScope;
import jp.root42.r42fw.export.web.ui.components.scope.LocalVariableScopeUtil;


/**
 * @since 1.0
 * @author root42 Inc.
 * @version $Id: SetLocal.java 3 2009-07-30 18:02:43Z takahashikzn $
 */
public class SetLocal
    extends ContextBean {

    /***/
    private String value;

    /***/
    private boolean evalBody;

    /**
     * @param stack
     * stack
     */
    public SetLocal(final ValueStack stack) {
        super(stack);
    }

    /** {@inheritDoc} */
    @Override
    public boolean end(final Writer writer, final String body) {
        final Object o;
        if (this.value == null) {
            if (StringUtils.isEmpty(body)) {
                o = this.findValue("top");
            } else if (this.evalBody) {
                o = this.findValue(body);
            } else {
                o = body;
            }
        } else {
            try {
                o = this.findValue(this.value);
            } catch (final RuntimeException e) {
                throw new RuntimeException("value = " + this.value, e);
            }
        }

        // ----
        final LocalVariableScope localVariableScope =
            this.getEnclosingLocalVariableScope();

        localVariableScope.setVar(this.getVar(), o);

        return super.end(writer, "");
    }

    /**
     * 現在のset-localタグを囲っているblockタグを取得する。
     * 
     * @return Block
     */
    protected LocalVariableScope getEnclosingLocalVariableScope() {
        return LocalVariableScopeUtil.getEnclosingLocalVariableScope(this);
    }

    /**
     * @param value
     * value
     */
    public void setValue(final String value) {
        this.value = value;
    }

    /**
     * @param evalBody
     * evalBody
     */
    public void setEvalBody(final boolean evalBody) {
        this.evalBody = evalBody;
    }

    /** {@inheritDoc} */
    @Override
    public boolean usesBody() {
        return true;
    }
}
