/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionImplementor;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

class SpringSessionSynchronization
implements TransactionSynchronization,
Ordered {
    private final SessionHolder sessionHolder;
    private final SessionFactory sessionFactory;
    private final SQLExceptionTranslator jdbcExceptionTranslator;
    private final boolean newSession;
    private boolean hibernateTransactionCompletion = false;
    private Transaction jtaTransaction;
    private boolean holderActive = true;

    public SpringSessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator, boolean newSession) {
        this.sessionHolder = sessionHolder;
        this.sessionFactory = sessionFactory;
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
        this.newSession = newSession;
        TransactionManager jtaTm = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, sessionHolder.getAnySession());
        if (jtaTm != null) {
            this.hibernateTransactionCompletion = true;
            try {
                this.jtaTransaction = jtaTm.getTransaction();
            }
            catch (SystemException ex) {
                throw new DataAccessResourceFailureException("Could not access JTA transaction", (Throwable)ex);
            }
        }
    }

    private Session getCurrentSession() {
        Session session = null;
        if (this.jtaTransaction != null) {
            session = this.sessionHolder.getSession(this.jtaTransaction);
        }
        if (session == null) {
            session = this.sessionHolder.getSession();
        }
        return session;
    }

    public int getOrder() {
        return 900;
    }

    public void suspend() {
        if (this.holderActive) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            this.getCurrentSession().disconnect();
        }
    }

    public void resume() {
        if (this.holderActive) {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
        }
    }

    public void beforeCommit(boolean readOnly) throws DataAccessException {
        Session session;
        if (!readOnly && !(session = this.getCurrentSession()).getFlushMode().lessThan(FlushMode.COMMIT)) {
            try {
                SessionFactoryUtils.logger.debug((Object)"Flushing Hibernate Session on transaction synchronization");
                session.flush();
            }
            catch (HibernateException ex) {
                if (this.jdbcExceptionTranslator != null && ex instanceof JDBCException) {
                    JDBCException jdbcEx = (JDBCException)ex;
                    throw this.jdbcExceptionTranslator.translate("Hibernate flushing: " + jdbcEx.getMessage(), jdbcEx.getSQL(), jdbcEx.getSQLException());
                }
                throw SessionFactoryUtils.convertHibernateAccessException(ex);
            }
        }
    }

    public void beforeCompletion() {
        Session session;
        if (this.jtaTransaction != null && (session = this.sessionHolder.removeSession(this.jtaTransaction)) != null) {
            if (this.sessionHolder.isEmpty()) {
                TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.sessionFactory);
                this.holderActive = false;
            }
            if (session != this.sessionHolder.getSession()) {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.sessionFactory);
            } else {
                if (this.sessionHolder.getPreviousFlushMode() != null) {
                    session.setFlushMode(this.sessionHolder.getPreviousFlushMode());
                }
                session.disconnect();
            }
            return;
        }
        if (this.newSession) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            this.holderActive = false;
            if (this.hibernateTransactionCompletion) {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(this.sessionHolder.getSession(), this.sessionFactory);
            }
        } else {
            session = this.sessionHolder.getSession();
            if (this.sessionHolder.getPreviousFlushMode() != null) {
                session.setFlushMode(this.sessionHolder.getPreviousFlushMode());
            }
            if (this.hibernateTransactionCompletion) {
                session.disconnect();
            }
        }
    }

    public void afterCommit() {
    }

    public void afterCompletion(int status) {
        if (!this.hibernateTransactionCompletion || !this.newSession) {
            Session session = this.sessionHolder.getSession();
            if (session instanceof SessionImplementor) {
                ((SessionImplementor)session).afterTransactionCompletion(status == 0, null);
            }
            if (this.newSession) {
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.sessionFactory);
            } else if (!this.hibernateTransactionCompletion) {
                session.disconnect();
            }
        }
        if (!this.newSession && status != 0) {
            this.sessionHolder.getSession().clear();
        }
        if (this.sessionHolder.doesNotHoldNonDefaultSession()) {
            this.sessionHolder.setSynchronizedWithTransaction(false);
        }
    }
}

