/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.generic.FieldInstruction;
import org.aspectj.apache.bcel.generic.INVOKEINTERFACE;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.MULTIANEWARRAY;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.util.ClassLoaderReference;
import org.aspectj.apache.bcel.util.ClassLoaderRepository;
import org.aspectj.apache.bcel.util.ClassPath;
import org.aspectj.apache.bcel.util.NonCachingClassLoaderRepository;
import org.aspectj.apache.bcel.util.Repository;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationOnTypeMunger;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ICrossReferenceHandler;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MemberImpl;
import org.aspectj.weaver.MemberKind;
import org.aspectj.weaver.NewParentTypeMunger;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeakClassLoaderReference;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelAdvice;
import org.aspectj.weaver.bcel.BcelCflowCounterFieldAdder;
import org.aspectj.weaver.bcel.BcelCflowStackFieldAdder;
import org.aspectj.weaver.bcel.BcelMethod;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelPerClauseAspectAdder;
import org.aspectj.weaver.bcel.BcelTypeMunger;
import org.aspectj.weaver.bcel.ClassPathManager;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.LazyMethodGen;
import org.aspectj.weaver.patterns.DeclareAnnotation;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.TraceFactory;

public class BcelWorld
extends World
implements Repository {
    private ClassPathManager classPath;
    protected Repository delegate;
    private WeakClassLoaderReference loaderRef;
    private static Trace trace = TraceFactory.getTraceFactory().getTrace(class$org$aspectj$weaver$bcel$BcelWorld == null ? (class$org$aspectj$weaver$bcel$BcelWorld = BcelWorld.class$("org.aspectj.weaver.bcel.BcelWorld")) : class$org$aspectj$weaver$bcel$BcelWorld);
    static /* synthetic */ Class class$org$aspectj$weaver$bcel$BcelWorld;

    public BcelWorld() {
        this("");
    }

    public BcelWorld(String cp) {
        this(BcelWorld.makeDefaultClasspath(cp), IMessageHandler.THROW, null);
    }

    private static List makeDefaultClasspath(String cp) {
        ArrayList classPath = new ArrayList();
        classPath.addAll(BcelWorld.getPathEntries(cp));
        classPath.addAll(BcelWorld.getPathEntries(ClassPath.getClassPath()));
        return classPath;
    }

    private static List getPathEntries(String s) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(s, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            ret.add(tok.nextToken());
        }
        return ret;
    }

    public BcelWorld(List classPath, IMessageHandler handler, ICrossReferenceHandler xrefHandler) {
        this.classPath = new ClassPathManager(classPath, handler);
        this.setMessageHandler(handler);
        this.setCrossReferenceHandler(xrefHandler);
        this.delegate = this;
    }

    public BcelWorld(ClassPathManager cpm, IMessageHandler handler, ICrossReferenceHandler xrefHandler) {
        this.classPath = cpm;
        this.setMessageHandler(handler);
        this.setCrossReferenceHandler(xrefHandler);
        this.delegate = this;
    }

    public BcelWorld(ClassLoader loader, IMessageHandler handler, ICrossReferenceHandler xrefHandler) {
        this.classPath = null;
        this.loaderRef = new WeakClassLoaderReference(loader);
        this.setMessageHandler(handler);
        this.setCrossReferenceHandler(xrefHandler);
    }

    public void ensureRepositorySetup() {
        if (this.delegate == null) {
            this.delegate = this.getClassLoaderRepositoryFor(this.loaderRef);
        }
    }

    public Repository getClassLoaderRepositoryFor(ClassLoaderReference loader) {
        if (this.bcelRepositoryCaching) {
            return new ClassLoaderRepository(loader);
        }
        return new NonCachingClassLoaderRepository(loader);
    }

    public void addPath(String name) {
        this.classPath.addPath(name, this.getMessageHandler());
    }

    public static Type makeBcelType(UnresolvedType type) {
        return Type.getType(type.getErasureSignature());
    }

    static Type[] makeBcelTypes(UnresolvedType[] types) {
        Type[] ret = new Type[types.length];
        int len = types.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = BcelWorld.makeBcelType(types[i]);
        }
        return ret;
    }

    static String[] makeBcelTypesAsClassNames(UnresolvedType[] types) {
        String[] ret = new String[types.length];
        int len = types.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = types[i].getName();
        }
        return ret;
    }

    public static UnresolvedType fromBcel(Type t) {
        return UnresolvedType.forSignature(t.getSignature());
    }

    static UnresolvedType[] fromBcel(Type[] ts) {
        UnresolvedType[] ret = new UnresolvedType[ts.length];
        int len = ts.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = BcelWorld.fromBcel(ts[i]);
        }
        return ret;
    }

    public ResolvedType resolve(Type t) {
        return this.resolve(BcelWorld.fromBcel(t));
    }

    protected ReferenceTypeDelegate resolveDelegate(ReferenceType ty) {
        String name = ty.getName();
        this.ensureAdvancedConfigurationProcessed();
        JavaClass jc = this.lookupJavaClass(this.classPath, name);
        if (jc == null) {
            return null;
        }
        return this.buildBcelDelegate(ty, jc, false);
    }

    public BcelObjectType buildBcelDelegate(ReferenceType resolvedTypeX, JavaClass jc, boolean exposedToWeaver) {
        BcelObjectType ret = new BcelObjectType(resolvedTypeX, jc, exposedToWeaver);
        return ret;
    }

    private JavaClass lookupJavaClass(ClassPathManager classPath, String name) {
        if (classPath == null) {
            try {
                this.ensureRepositorySetup();
                JavaClass jc = this.delegate.loadClass(name);
                if (trace.isTraceEnabled()) {
                    trace.event("lookupJavaClass", (Object)this, new Object[]{name, jc});
                }
                return jc;
            }
            catch (ClassNotFoundException e) {
                if (trace.isTraceEnabled()) {
                    trace.error("Unable to find class '" + name + "' in repository", e);
                }
                return null;
            }
        }
        try {
            ClassPathManager.ClassFile file = classPath.find(UnresolvedType.forName(name));
            if (file == null) {
                return null;
            }
            ClassParser parser = new ClassParser(file.getInputStream(), file.getPath());
            JavaClass jc = parser.parse();
            file.close();
            return jc;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public BcelObjectType addSourceObjectType(JavaClass jc) {
        BcelObjectType ret = null;
        String signature = UnresolvedType.forName(jc.getClassName()).getSignature();
        ResolvedType fromTheMap = this.typeMap.get(signature);
        if (fromTheMap != null && !(fromTheMap instanceof ReferenceType)) {
            StringBuffer exceptionText = new StringBuffer();
            exceptionText.append("Found invalid (not a ReferenceType) entry in the type map. ");
            exceptionText.append("Signature=[" + signature + "] Found=[" + fromTheMap + "] Class=[" + fromTheMap.getClass() + "]");
            throw new BCException(exceptionText.toString());
        }
        ReferenceType nameTypeX = (ReferenceType)fromTheMap;
        if (nameTypeX == null) {
            if (jc.isGeneric() && this.isInJava5Mode()) {
                nameTypeX = ReferenceType.fromTypeX(UnresolvedType.forRawTypeName(jc.getClassName()), this);
                ret = this.buildBcelDelegate(nameTypeX, jc, true);
                ReferenceType genericRefType = new ReferenceType(UnresolvedType.forGenericTypeSignature(signature, ret.getDeclaredGenericSignature()), (World)this);
                nameTypeX.setDelegate(ret);
                genericRefType.setDelegate(ret);
                nameTypeX.setGenericType(genericRefType);
                this.typeMap.put(signature, nameTypeX);
            } else {
                nameTypeX = new ReferenceType(signature, (World)this);
                ret = this.buildBcelDelegate(nameTypeX, jc, true);
                this.typeMap.put(signature, nameTypeX);
            }
        } else {
            ret = this.buildBcelDelegate(nameTypeX, jc, true);
        }
        return ret;
    }

    void deleteSourceObjectType(UnresolvedType ty) {
        this.typeMap.remove(ty.getSignature());
    }

    public static Member makeFieldJoinPointSignature(LazyClassGen cg, FieldInstruction fi) {
        ConstantPool cpg = cg.getConstantPool();
        return MemberImpl.field(fi.getClassName(cpg), fi.opcode == 178 || fi.opcode == 179 ? 8 : 0, fi.getName(cpg), fi.getSignature(cpg));
    }

    public Member makeJoinPointSignatureFromMethod(LazyMethodGen mg, MemberKind kind) {
        BcelMethod ret = mg.getMemberView();
        if (ret == null) {
            int mods = mg.getAccessFlags();
            if (mg.getEnclosingClass().isInterface()) {
                mods |= 0x200;
            }
            return new ResolvedMemberImpl(kind, UnresolvedType.forName(mg.getClassName()), mods, BcelWorld.fromBcel(mg.getReturnType()), mg.getName(), BcelWorld.fromBcel(mg.getArgumentTypes()));
        }
        return ret;
    }

    public Member makeJoinPointSignatureForMonitorEnter(LazyClassGen cg, InstructionHandle h) {
        return MemberImpl.monitorEnter();
    }

    public Member makeJoinPointSignatureForMonitorExit(LazyClassGen cg, InstructionHandle h) {
        return MemberImpl.monitorExit();
    }

    public Member makeJoinPointSignatureForArrayConstruction(LazyClassGen cg, InstructionHandle handle) {
        Instruction i = handle.getInstruction();
        ConstantPool cpg = cg.getConstantPool();
        MemberImpl retval = null;
        if (i.opcode == 189) {
            Type ot = i.getType(cpg);
            UnresolvedType ut = BcelWorld.fromBcel(ot);
            ut = UnresolvedType.makeArray(ut, 1);
            retval = MemberImpl.method(ut, 1, ResolvedType.VOID, "<init>", new ResolvedType[]{ResolvedType.INT});
        } else if (i instanceof MULTIANEWARRAY) {
            MULTIANEWARRAY arrayInstruction = (MULTIANEWARRAY)i;
            UnresolvedType ut = null;
            int dimensions = arrayInstruction.getDimensions();
            ObjectType ot = arrayInstruction.getLoadClassType(cpg);
            if (ot != null) {
                ut = BcelWorld.fromBcel(ot);
                ut = UnresolvedType.makeArray(ut, dimensions);
            } else {
                Type t = arrayInstruction.getType(cpg);
                ut = BcelWorld.fromBcel(t);
            }
            UnresolvedType[] parms = new ResolvedType[dimensions];
            for (int ii = 0; ii < dimensions; ++ii) {
                parms[ii] = ResolvedType.INT;
            }
            retval = MemberImpl.method(ut, 1, ResolvedType.VOID, "<init>", parms);
        } else if (i.opcode == 188) {
            Type ot = i.getType();
            UnresolvedType ut = BcelWorld.fromBcel(ot);
            retval = MemberImpl.method(ut, 1, ResolvedType.VOID, "<init>", new ResolvedType[]{ResolvedType.INT});
        } else {
            throw new BCException("Cannot create array construction signature for this non-array instruction:" + i);
        }
        return retval;
    }

    public Member makeJoinPointSignatureForMethodInvocation(LazyClassGen cg, InvokeInstruction ii) {
        int modifier;
        ConstantPool cpg = cg.getConstantPool();
        String name = ii.getName(cpg);
        String declaring = ii.getClassName(cpg);
        UnresolvedType declaringType = null;
        String signature = ii.getSignature(cpg);
        int n = ii instanceof INVOKEINTERFACE ? 512 : (ii.opcode == 184 ? 8 : (modifier = ii.opcode == 183 && !name.equals("<init>") ? 2 : 0));
        if (ii.opcode == 184) {
            ResolvedType appearsDeclaredBy = this.resolve(declaring);
            Iterator iterator = appearsDeclaredBy.getMethods();
            while (iterator.hasNext()) {
                ResolvedMember method = (ResolvedMember)iterator.next();
                if (!method.isStatic() || !name.equals(method.getName()) || !signature.equals(method.getSignature())) continue;
                declaringType = method.getDeclaringType();
                break;
            }
        }
        if (declaringType == null) {
            declaringType = declaring.charAt(0) == '[' ? UnresolvedType.forSignature(declaring) : UnresolvedType.forName(declaring);
        }
        return MemberImpl.method(declaringType, modifier, name, signature);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("BcelWorld(");
        buf.append(")");
        return buf.toString();
    }

    public Advice createAdviceMunger(AjAttribute.AdviceAttribute attribute, Pointcut pointcut, Member signature) {
        return new BcelAdvice(attribute, pointcut, signature, null);
    }

    public ConcreteTypeMunger concreteTypeMunger(ResolvedTypeMunger munger, ResolvedType aspectType) {
        return new BcelTypeMunger(munger, aspectType);
    }

    public ConcreteTypeMunger makeCflowStackFieldAdder(ResolvedMember cflowField) {
        return new BcelCflowStackFieldAdder(cflowField);
    }

    public ConcreteTypeMunger makeCflowCounterFieldAdder(ResolvedMember cflowField) {
        return new BcelCflowCounterFieldAdder(cflowField);
    }

    public ConcreteTypeMunger makePerClauseAspect(ResolvedType aspect, PerClause.Kind kind) {
        return new BcelPerClauseAspectAdder(aspect, kind);
    }

    public static BcelObjectType getBcelObjectType(ResolvedType concreteAspect) {
        ReferenceTypeDelegate rtDelegate = ((ReferenceType)concreteAspect).getDelegate();
        if (rtDelegate instanceof BcelObjectType) {
            return (BcelObjectType)rtDelegate;
        }
        return null;
    }

    public void tidyUp() {
        this.classPath.closeArchives();
        this.typeMap.report();
        ResolvedType.resetPrimitives();
    }

    public JavaClass findClass(String className) {
        return this.lookupJavaClass(this.classPath, className);
    }

    public JavaClass loadClass(String className) throws ClassNotFoundException {
        return this.lookupJavaClass(this.classPath, className);
    }

    public void storeClass(JavaClass clazz) {
    }

    public void removeClass(JavaClass clazz) {
        throw new RuntimeException("Not implemented");
    }

    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        throw new RuntimeException("Not implemented");
    }

    public void clear() {
        this.delegate.clear();
    }

    public void validateType(UnresolvedType type) {
        ResolvedType result = this.typeMap.get(type.getSignature());
        if (result == null) {
            return;
        }
        if (!result.isExposedToWeaver()) {
            return;
        }
        ReferenceType rt = (ReferenceType)result;
        rt.getDelegate().ensureDelegateConsistent();
    }

    private boolean applyDeclareParents(DeclareParents p, ResolvedType onType) {
        boolean didSomething = false;
        List newParents = p.findMatchingNewParents(onType, true);
        if (!newParents.isEmpty()) {
            didSomething = true;
            BcelObjectType classType = BcelWorld.getBcelObjectType(onType);
            Iterator j = newParents.iterator();
            while (j.hasNext()) {
                ResolvedType newParent = (ResolvedType)j.next();
                classType.addParent(newParent);
                NewParentTypeMunger newParentMunger = new NewParentTypeMunger(newParent);
                newParentMunger.setSourceLocation(p.getSourceLocation());
                onType.addInterTypeMunger(new BcelTypeMunger(newParentMunger, this.getCrosscuttingMembersSet().findAspectDeclaringParents(p)));
            }
        }
        return didSomething;
    }

    private boolean applyDeclareAtType(DeclareAnnotation decA, ResolvedType onType, boolean reportProblems) {
        boolean didSomething = false;
        if (decA.matches(onType)) {
            if (onType.hasAnnotation(decA.getAnnotationX().getType())) {
                return false;
            }
            AnnotationAJ annoX = decA.getAnnotationX();
            boolean isOK = this.checkTargetOK(decA, onType, annoX);
            if (isOK) {
                didSomething = true;
                AnnotationOnTypeMunger newAnnotationTM = new AnnotationOnTypeMunger(annoX);
                newAnnotationTM.setSourceLocation(decA.getSourceLocation());
                onType.addInterTypeMunger(new BcelTypeMunger(newAnnotationTM, decA.getAspect().resolve(this)));
                decA.copyAnnotationTo(onType);
            }
        }
        return didSomething;
    }

    private boolean checkTargetOK(DeclareAnnotation decA, ResolvedType onType, AnnotationAJ annoX) {
        return !annoX.specifiesTarget() || (!onType.isAnnotation() || annoX.allowedOnAnnotationType()) && annoX.allowedOnRegularType();
    }

    protected void weaveInterTypeDeclarations(ResolvedType onType) {
        boolean typeChanged;
        List declareParentsList = this.getCrosscuttingMembersSet().getDeclareParents();
        if (onType.isRawType()) {
            onType = onType.getGenericType();
        }
        onType.clearInterTypeMungers();
        ArrayList<DeclareParents> decpToRepeat = new ArrayList<DeclareParents>();
        boolean aParentChangeOccurred = false;
        boolean anAnnotationChangeOccurred = false;
        Iterator i = declareParentsList.iterator();
        while (i.hasNext()) {
            DeclareParents decp = (DeclareParents)i.next();
            typeChanged = this.applyDeclareParents(decp, onType);
            if (typeChanged) {
                aParentChangeOccurred = true;
                continue;
            }
            if (decp.getChild().isStarAnnotation()) continue;
            decpToRepeat.add(decp);
        }
        i = this.getCrosscuttingMembersSet().getDeclareAnnotationOnTypes().iterator();
        while (i.hasNext()) {
            DeclareAnnotation decA = (DeclareAnnotation)i.next();
            typeChanged = this.applyDeclareAtType(decA, onType, true);
            if (!typeChanged) continue;
            anAnnotationChangeOccurred = true;
        }
        while ((aParentChangeOccurred || anAnnotationChangeOccurred) && !decpToRepeat.isEmpty()) {
            boolean typeChanged2;
            aParentChangeOccurred = false;
            anAnnotationChangeOccurred = false;
            ArrayList<DeclareParents> decpToRepeatNextTime = new ArrayList<DeclareParents>();
            Iterator iter = decpToRepeat.iterator();
            while (iter.hasNext()) {
                DeclareParents decp = (DeclareParents)iter.next();
                typeChanged2 = this.applyDeclareParents(decp, onType);
                if (typeChanged2) {
                    aParentChangeOccurred = true;
                    continue;
                }
                decpToRepeatNextTime.add(decp);
            }
            iter = this.getCrosscuttingMembersSet().getDeclareAnnotationOnTypes().iterator();
            while (iter.hasNext()) {
                DeclareAnnotation decA = (DeclareAnnotation)iter.next();
                typeChanged2 = this.applyDeclareAtType(decA, onType, false);
                if (!typeChanged2) continue;
                anAnnotationChangeOccurred = true;
            }
            decpToRepeat = decpToRepeatNextTime;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

